#ifndef StatisticsReporterXML_h
#define StatisticsReporterXML_h

#ifndef StatisticsReporter_h
#include "StatisticsReporter.h"
#endif

#ifndef Stats_h
#include "Stats.h"
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

using namespace std;

namespace doctorj
{
    class StatisticsReporterXML;

    class XMLNode
    {
    public:
        XMLNode(const string& label, StatisticsReporterXML* const reporter);

        virtual ~XMLNode();

    private:
        string label_;

        StatisticsReporterXML* reporter_;
    };

    class StatisticsReporterXML : public StatisticsReporter
    {
        friend class XMLNode;
    public:

        StatisticsReporterXML(ostream& os);

        virtual ~StatisticsReporterXML();

        virtual void writeString(const string& label, const string& str);

        virtual void writeImportCount(int nImports);

        virtual void writeTotalLines(int nLines);

        virtual void writeTypesCount(int nConcreteClasses, 
                                     int nAbstractClasses, int nInterfaces,
                                     int sum, double mean, double standardDeviation, 
                                     int max, int min);

        virtual void writeMethodCount(int nStaticMethods, int nInstanceMethods,
                                      int sum, 
                                      double mean, double standardDeviation,
                                      int max, int min);
        
        void writeLabel(const string& label);

        virtual void writeFullReport(ProjectStatistics* const ps);

    protected:

        virtual void outputSummary(int nLines,
                                   int nTypes,
                                   int nConcretes,
                                   int nAbstracts,
                                   int nInterfaces,
                                   const vector<int>& typeLines,
                                   int nStaticMethods,
                                   int nInstanceMethods,
                                   const vector<int>& methodLines,
                                   int nStaticFields,
                                   int nInstanceFields);

        virtual void outputInnerType(const string& type, 
                                     const string& name,
                                     const vector<InnerTypeStatistics*>& innerTypes,
                                     int nLines,
                                     int nStaticMethods,
                                     int nInstanceMethods,
                                     const vector<int>& methods,
                                     int nStaticFields,
                                     int nInstanceFields);

        template <typename Type>
        void writeStats(const vector<Type>& vec)
        {
            XMLNode node("Lines", this);
            Stats<Type> stats(vec);
            write("Sum",               stats.sum());
            write("Mean",              stats.mean());
            write("StandardDeviation", stats.standardDeviation());
            write("Highest",           stats.max());
            write("Lowest",            stats.min());
        }

    };
    
}


#endif //! StatisticsReporterXML_h
