#ifndef StatisticsReporter_h
#define StatisticsReporter_h

#ifndef Writer_h
#include "Writer.h"
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

using namespace std;

namespace doctorj
{
    class ProjectStatistics;
    class CompilationUnitStatistics;
    class InnerTypeStatistics;
    
    class StatisticsReporter : public Writer
    {
    public:
        
        StatisticsReporter(ostream& os);

        virtual ~StatisticsReporter();

        virtual void writeSummary(ProjectStatistics* const st);

        virtual void writeFullReport(ProjectStatistics* const st) = 0;

        virtual void writeInnerType(InnerTypeStatistics* const ts);

    protected:

        virtual void count(const ProjectStatistics* const ps,
                           int* const nConcretes,
                           int* const nAbstracts,
                           int* const nInterfaces,
                           vector<int>* const typeLines,
                           int* const nStaticMethods,
                           int* const nInstanceMethods,
                           vector<int>* const methodLines,
                           int* const nStaticFields,
                           int* const nInstanceFields);

        virtual void count(const InnerTypeStatistics* const cts,
                           int* const nConcretes,
                           int* const nAbstracts,
                           int* const nInterfaces,
                           vector<int>* const typeLines,
                           int* const nStaticMethods,
                           int* const nInstanceMethods,
                           vector<int>* const methodLines,
                           int* const nStaticFields,
                           int* const nInstanceFields);

        virtual void count(const CompilationUnitStatistics* const cus,
                           int* const nConcretes,
                           int* const nAbstracts,
                           int* const nInterfaces,
                           vector<int>* const typeLines,
                           int* const nStaticMethods,
                           int* const nInstanceMethods,
                           vector<int>* const methodLines,
                           int* const nStaticFields,
                           int* const nInstanceFields);

        virtual void outputSummary(int nLines,
                                   int nTypes,
                                   int nConcretes,
                                   int nAbstracts,
                                   int nInterfaces,
                                   const vector<int>& typeLines,
                                   int nStaticMethods,
                                   int nInstanceMethods,
                                   const vector<int>& methodLines,
                                   int nStaticFields,
                                   int nInstanceFields) = 0;


        virtual void outputInnerType(const string& type, 
                                     const string& name,
                                     const vector<InnerTypeStatistics*>& innerTypes,
                                     int nLines,
                                     int nStaticMethods,
                                     int nInstanceMethods,
                                     const vector<int>& methods,
                                     int nStaticFields,
                                     int nInstanceFields) = 0;
        
    };

}

#endif //! StatisticsReporter_h
