#ifndef StatisticsAnalyzerApp_h
#include "StatisticsAnalyzerApp.h"
#endif

#ifndef StatisticsAnalyzer_h
#include "StatisticsAnalyzer.h"
#endif

#ifndef AST_h
#include "AST.h"
#endif

#ifndef StatisticsReporter_h
#include "StatisticsReporter.h"
#endif

#ifndef StatisticsReporterXML_h
#include "StatisticsReporterXML.h"
#endif

#ifndef StatisticsReporterText_h
#include "StatisticsReporterText.h"
#endif

using namespace doctorj;

StatisticsAnalyzerApp::StatisticsAnalyzerApp() : App("statj", "Java project statistics analyzer"), outputXML_(false), summaryOnly_(false)
{
    buildOptions();
}

StatisticsAnalyzerApp::~StatisticsAnalyzerApp()
{
}

void StatisticsAnalyzerApp::addOptions(yagol::AppOptionSet* const opts)
{
    opts->addOption("statistics.xml",     "whether to display the results in XML", &outputXML_);
    opts->addOption("statistics.summary", "whether to display only the statistics summary, not file by file", &summaryOnly_);
}

void StatisticsAnalyzerApp::execute(AstProject* const proj)
{
    StatisticsAnalyzer sa;
    proj->getProcessed(&sa);

    StatisticsReporter* reporter = NULL;
    if (outputXML_) {
        reporter = new StatisticsReporterXML(cout);
    }
    else {
        reporter = new StatisticsReporterText(cout);
    }

    if (summaryOnly_) {
        reporter->writeSummary(sa.getProjectStatistics());
    }
    else {
        reporter->writeFullReport(sa.getProjectStatistics());
    }
}
