#ifndef StatisticsAnalyzer_h
#define StatisticsAnalyzer_h

#ifndef Processor_h
#include "Processor.h"
#endif

#ifndef CompilationUnitStatistics_h
#include "CompilationUnitStatistics.h"
#endif

#ifndef InnerTypeStatistics_h
#include "InnerTypeStatistics.h"
#endif


namespace doctorj
{
    class ProjectStatistics;

    class StatisticsAnalyzer : public Processor
    {
    public:
        StatisticsAnalyzer();

        virtual ~StatisticsAnalyzer();

        virtual void process(AstClassDeclaration* const cd,
                             AstModifierList* const modifiers,
                             AstName* const extended,
                             AstImplementsInterfaceList* const implemented);

        virtual void process(AstClassDeclarationModsBaseless* const cdmb);

        virtual void process(AstClassDeclarationModsExtends* const cdme);

        virtual void process(AstClassDeclarationModsExtendsImplements* const cdmei);

        virtual void process(AstClassDeclarationModsImplements* const cdmi);

        virtual void process(AstClassDeclarationNoModsBaseless* const cdnmb);

        virtual void process(AstClassDeclarationNoModsExtends* const cdnme);

        virtual void process(AstClassDeclarationNoModsExtendsImplements* const cdnmei);

        virtual void process(AstClassDeclarationNoModsImplements* const cdnmi);

        virtual void process(AstClassMemberDeclaration* const cmd,
                             AstModifierList* const modifiers,
                             AstName* const extended,
                             AstImplementsInterfaceList* const implemented);

        virtual void process(AstClassMemberDeclarationModsExtendsImplements* const cmdmei);

        virtual void process(AstClassMemberDeclarationModsExtendsNoImplements* const cmdmeni);

        virtual void process(AstClassMemberDeclarationModsNoExtendsImplements* const cmdmnei);

        virtual void process(AstClassMemberDeclarationModsNoExtendsNoImplements* const cmdmneni);

        virtual void process(AstClassMemberDeclarationNoModsExtendsImplements* const cmdnmei);

        virtual void process(AstClassMemberDeclarationNoModsExtendsNoImplements* const cmdnmeni);

        virtual void process(AstClassMemberDeclarationNoModsNoExtendsImplements* const cmdnmnei);

        virtual void process(AstClassMemberDeclarationNoModsNoExtendsNoImplements* const cmdnmneni);

        virtual void process(AstCompilationUnit* const cu,
                             AstTypeDeclarationList* const types,
                             AstImportDeclarationList* const imports);

        virtual void process(AstCompilationUnitEmpty* const cue);

        virtual void process(AstCompilationUnitImp* const cui);

        virtual void process(AstCompilationUnitImpTypes* const cuit);

        virtual void process(AstCompilationUnitPkg* const cup);

        virtual void process(AstCompilationUnitPkgImp* const cupi);

        virtual void process(AstCompilationUnitPkgImpTypes* const cupit);

        virtual void process(AstCompilationUnitPkgTypes* const cupt);

        virtual void process(AstCompilationUnitTypes* const cut);

        virtual void process(AstFieldDeclaration* const fd,
                             AstModifierList* const modifiers);

        virtual void process(AstFieldDeclarationMods* const fdm);

        virtual void process(AstFieldDeclarationNoMods* const fdnm);

        virtual void process(AstInterfaceDeclaration* const id,
                             AstModifierList* const modifiers,
                             AstExtendsInterfaceList* const extended);

        virtual void process(AstInterfaceDeclarationModsExtends* const idme);

        virtual void process(AstInterfaceDeclarationModsNoExtends* const idmne);

        virtual void process(AstInterfaceDeclarationNoModsExtends* const idnme);

        virtual void process(AstInterfaceDeclarationNoModsNoExtends* const idnmne);

        virtual void process(AstMethodDeclaration* const md);

        virtual void process(AstMethodDeclarationBlock* const mdb);

        virtual void process(AstMethodDeclarationSemicolon* const mds);

        ProjectStatistics* getProjectStatistics();
             
    private:

        /**
         * Contains the statistics for all files.
         */
        ProjectStatistics* projectStats_;

        /**
         * Contains the statistics for the current compilation unit.
         */
        CompilationUnitStatistics* cuStats_;

        /**
         * Contains the statistics for the current type (class or interface).
         */
        InnerTypeStatistics* typeStats_;

    };
}

#endif //! StatisticsAnalyzer_h
