#ifndef CompilationUnitStatistics_h
#define CompilationUnitStatistics_h

#ifndef Statistics_h
#include "Statistics.h"
#endif

#ifndef InnerTypeStatistics_h
#include "InnerTypeStatistics.h"
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

using namespace std;

namespace doctorj
{
    class CompilationUnitStatistics : public Statistics
    {
    public:
        CompilationUnitStatistics(const string& filename, int nLines, int nImports);

        virtual ~CompilationUnitStatistics();

        virtual int getImportCount() const;

        virtual int getStaticMethodsCount() const;

        virtual int getInstanceMethodsCount() const;

        virtual int getStaticFieldsCount() const;

        virtual int getInstanceFieldsCount() const;

        virtual const vector<InnerTypeStatistics*>& types() const;

        virtual void addType(InnerTypeStatistics* const cts);

    private:

        int nImports_;

        vector<InnerTypeStatistics*> containedTypes_;

    };
}

#endif //! CompilationUnitStatistics_h
