#ifndef Processor_h
#define Processor_h

#ifndef AST_h
#include "AST.h"
#endif

namespace doctorj
{
    class AstLeaf;
    class AstNode;

    class Processor
    {
    public:
        Processor();

        virtual ~Processor();

        virtual void traverse(AstNode* const n);

        virtual void traverse(AstLeaf* const l);

        virtual void traverse(AstItem* const i);

        virtual void process(AstAbstract* const a);

        virtual void process(AstAbstractMethodDeclaration* const amd);

        virtual void process(AstAdditiveExpression* const ae);

        virtual void process(AstAdditiveExpressionMinus* const aem);

        virtual void process(AstAdditiveExpressionPlus* const aep);

        virtual void process(AstAnd* const a);

        virtual void process(AstAndExpression* const ae);

        virtual void process(AstAndand* const a);

        virtual void process(AstAndeq* const a);

        virtual void process(AstArrayAccess* const aa);

        virtual void process(AstArrayAccessName* const aan);

        virtual void process(AstArrayAccessPrimary* const aap);

        virtual void process(AstArrayCreationExpression* const ace);

        virtual void process(AstArrayCreationExpressionNameDimsInit* const acendi);

        virtual void process(AstArrayCreationExpressionNameExprDims* const acened);

        virtual void process(AstArrayCreationExpressionNameExprNoDims* const acenend);

        virtual void process(AstArrayCreationExpressionPrimitiveDimsInit* const acepdi);

        virtual void process(AstArrayCreationExpressionPrimitiveExprDims* const aceped);

        virtual void process(AstArrayCreationExpressionPrimitiveExprNoDims* const acepend);

        virtual void process(AstArrayInitializer* const ai);

        virtual void process(AstArrayInitializerComma* const aic);

        virtual void process(AstArrayInitializerEmpty* const aie);

        virtual void process(AstArrayInitializerVars* const aiv);

        virtual void process(AstArrayInitializerVarsComma* const aivc);

        virtual void process(AstArrayNameType* const ant);

        virtual void process(AstArrayPrimitiveType* const apt);

        virtual void process(AstArrayType* const at);

        virtual void process(AstArrayTypeDotClass* const atdc);

        virtual void process(AstAssert* const a);

        virtual void process(AstAssertStatement* const a);

        virtual void process(AstAssertStatementOneExpression* const as);

        virtual void process(AstAssertStatementTwoExpressions* const as);

        virtual void process(AstAssignment* const a);

        virtual void process(AstAssignmentArray* const aa);

        virtual void process(AstAssignmentField* const af);

        virtual void process(AstAssignmentName* const an);

        virtual void process(AstAssignmentOperator* const ao);

        virtual void process(AstBlock* const b);

        virtual void process(AstBlockNoStatements* const bns);

        virtual void process(AstBlockStatementList* const bsl);

        virtual void process(AstBlockWStatements* const bWs);

        virtual void process(AstBoolean* const b);

        virtual void process(AstBooleanLiteral* const bl);

        virtual void process(AstBreak* const b);

        virtual void process(AstBreakStatement* const bs);

        virtual void process(AstBreakStatementId* const bsi);

        virtual void process(AstBreakStatementNoId* const bsni);

        virtual void process(AstByte* const b);

        virtual void process(AstCComment* const Cc);

        virtual void process(AstCase* const c);

        virtual void process(AstCastExpression* const ce);

        virtual void process(AstCastExpressionExpr* const cee);

        virtual void process(AstCastExpressionNameDims* const cend);

        virtual void process(AstCastExpressionPrimitiveDims* const cepd);

        virtual void process(AstCastExpressionPrimitiveNoDims* const cepnd);

        virtual void process(AstCatch* const c);

        virtual void process(AstCatchClause* const cc);

        virtual void process(AstCatchClauseList* const ccl);

        virtual void process(AstChar* const c);

        virtual void process(AstCharacterLiteral* const cl);

        virtual void process(AstClass* const c);

        virtual void process(AstClassBody* const cb);

        virtual void process(AstClassBodyDeclarationList* const cbdl);

        virtual void process(AstClassBodyDecls* const cbd);

        virtual void process(AstClassBodyEmpty* const cbe);

        virtual void process(AstClassDeclaration* const cd);

        virtual void process(AstClassDeclarationModsBaseless* const cdmb);

        virtual void process(AstClassDeclarationModsExtends* const cdme);

        virtual void process(AstClassDeclarationModsExtendsImplements* const cdmei);

        virtual void process(AstClassDeclarationModsImplements* const cdmi);

        virtual void process(AstClassDeclarationNoModsBaseless* const cdnmb);

        virtual void process(AstClassDeclarationNoModsExtends* const cdnme);

        virtual void process(AstClassDeclarationNoModsExtendsImplements* const cdnmei);

        virtual void process(AstClassDeclarationNoModsImplements* const cdnmi);

        virtual void process(AstClassInstanceCreationExpression* const cice);

        virtual void process(AstClassInstanceCreationExpressionNameExprBody* const ciceneb);

        virtual void process(AstClassInstanceCreationExpressionNameExprNoBody* const cicenenb);

        virtual void process(AstClassInstanceCreationExpressionNameIdExprBody* const cicenieb);

        virtual void process(AstClassInstanceCreationExpressionNameIdExprNoBody* const cicenienb);

        virtual void process(AstClassInstanceCreationExpressionNameIdNoExprBody* const cicenineb);

        virtual void process(AstClassInstanceCreationExpressionNameIdNoExprNoBody* const ciceninenb);

        virtual void process(AstClassInstanceCreationExpressionNameNoExprBody* const cicenneb);

        virtual void process(AstClassInstanceCreationExpressionNameNoExprNoBody* const cicennenb);

        virtual void process(AstClassInstanceCreationExpressionPrimaryExprBody* const cicepeb);

        virtual void process(AstClassInstanceCreationExpressionPrimaryExprNoBody* const cicepenb);

        virtual void process(AstClassInstanceCreationExpressionPrimaryNoExprBody* const cicepneb);

        virtual void process(AstClassInstanceCreationExpressionPrimaryNoExprNoBody* const cicepnenb);

        virtual void process(AstClassMemberDeclaration* const cmd);

        virtual void process(AstClassMemberDeclarationModsExtendsImplements* const cmdmei);

        virtual void process(AstClassMemberDeclarationModsExtendsNoImplements* const cmdmeni);

        virtual void process(AstClassMemberDeclarationModsNoExtendsImplements* const cmdmnei);

        virtual void process(AstClassMemberDeclarationModsNoExtendsNoImplements* const cmdmneni);

        virtual void process(AstClassMemberDeclarationNoModsExtendsImplements* const cmdnmei);

        virtual void process(AstClassMemberDeclarationNoModsExtendsNoImplements* const cmdnmeni);

        virtual void process(AstClassMemberDeclarationNoModsNoExtendsImplements* const cmdnmnei);

        virtual void process(AstClassMemberDeclarationNoModsNoExtendsNoImplements* const cmdnmneni);

        virtual void process(AstColon* const c);

        virtual void process(AstComma* const c);

        virtual void process(AstComment* const c);

        virtual void process(AstComp* const c);

        virtual void process(AstCompilationUnit* const cu);

        virtual void process(AstCompilationUnitEmpty* const cue);

        virtual void process(AstCompilationUnitImp* const cui);

        virtual void process(AstCompilationUnitImpTypes* const cuit);

        virtual void process(AstCompilationUnitPkg* const cup);

        virtual void process(AstCompilationUnitPkgImp* const cupi);

        virtual void process(AstCompilationUnitPkgImpTypes* const cupit);

        virtual void process(AstCompilationUnitPkgTypes* const cupt);

        virtual void process(AstCompilationUnitTypes* const cut);

        virtual void process(AstConditionalAndExpression* const cae);

        virtual void process(AstConditionalArithExpression* const cae);

        virtual void process(AstConditionalOrExpression* const coe);

        virtual void process(AstConst* const c);

        virtual void process(AstConstructorBody* const cb);

        virtual void process(AstConstructorBodyBlock* const cbb);

        virtual void process(AstConstructorBodyEmpty* const cbe);

        virtual void process(AstConstructorBodyExplicit* const cbe);

        virtual void process(AstConstructorBodyExplicitBlock* const cbeb);

        virtual void process(AstConstructorDeclaration* const cd);

        virtual void process(AstConstructorDeclarationModsNoThrows* const cdmnt);

        virtual void process(AstConstructorDeclarationModsThrows* const cdmt);

        virtual void process(AstConstructorDeclarationNoModsNoThrows* const cdnmnt);

        virtual void process(AstConstructorDeclarationNoModsThrows* const cdnmt);

        virtual void process(AstConstructorDeclarator* const cd);

        virtual void process(AstConstructorDeclaratorEmpty* const cde);

        virtual void process(AstConstructorDeclaratorParams* const cdp);

        virtual void process(AstContinue* const c);

        virtual void process(AstContinueStatement* const cs);

        virtual void process(AstContinueStatementId* const csi);

        virtual void process(AstContinueStatementNoId* const csni);

        virtual void process(AstCppComment* const cc);

        virtual void process(AstDefault* const d);

        virtual void process(AstDimension* const d);

        virtual void process(AstDimensionExpression* const de);

        virtual void process(AstDimensionExpressionList* const del);

        virtual void process(AstDimensionList* const dl);

        virtual void process(AstDiv* const d);

        virtual void process(AstDiveq* const d);

        virtual void process(AstDo* const d);

        virtual void process(AstDoStatement* const ds);

        virtual void process(AstDot* const d);

        virtual void process(AstDouble* const d);

        virtual void process(AstElse* const e);

        virtual void process(AstEq* const e);

        virtual void process(AstEqeq* const e);

        virtual void process(AstEqualityExpression* const ee);

        virtual void process(AstEqualityExpressionEq* const eee);

        virtual void process(AstEqualityExpressionNe* const een);

        virtual void process(AstExplicitConstructorInvocation* const eci);

        virtual void process(AstExplicitConstructorInvocationPrimarySuper* const ecips);

        virtual void process(AstExplicitConstructorInvocationPrimarySuperExpressions* const ecipse);

        virtual void process(AstExplicitConstructorInvocationPrimaryThis* const ecipt);

        virtual void process(AstExplicitConstructorInvocationPrimaryThisExpressions* const ecipte);

        virtual void process(AstExplicitConstructorInvocationSuper* const ecis);

        virtual void process(AstExplicitConstructorInvocationSuperExpressions* const ecise);

        virtual void process(AstExplicitConstructorInvocationThis* const ecit);

        virtual void process(AstExplicitConstructorInvocationThisExpressions* const ecite);

        virtual void process(AstExpressionList* const el);

        virtual void process(AstExpressionStatement* const es);

        virtual void process(AstExtends* const e);

        virtual void process(AstExtendsInterfaceList* const eil);

        virtual void process(AstFalseLiteral* const fl);

        virtual void process(AstFieldAccess* const fa);

        virtual void process(AstFieldAccessNameSuper* const fans);

        virtual void process(AstFieldAccessPrimary* const fap);

        virtual void process(AstFieldAccessSuper* const fas);

        virtual void process(AstFieldDeclaration* const fd);

        virtual void process(AstFieldDeclarationMods* const fdm);

        virtual void process(AstFieldDeclarationNoMods* const fdnm);

        virtual void process(AstFinal* const f);

        virtual void process(AstFinally* const f);

        virtual void process(AstFinallyBlock* const fb);

        virtual void process(AstFloat* const f);

        virtual void process(AstFloatingPointLiteral* const fpl);

        virtual void process(AstFloatingPointType* const fpt);

        virtual void process(AstFor* const f);

        virtual void process(AstForStatement* const fs);

        virtual void process(AstForStatementNoInitConditionNoUpdate* const fsnicnu);

        virtual void process(AstForStatementNoInitConditionUpdate* const fsnicu);

        virtual void process(AstForStatementNoInitNoConditionNoUpdate* const fsnincnu);

        virtual void process(AstForStatementNoInitNoConditionUpdate* const fsnincu);

        virtual void process(AstForStatementStmtsConditionNoUpdate* const fsscnu);

        virtual void process(AstForStatementStmtsConditionUpdate* const fsscu);

        virtual void process(AstForStatementStmtsNoConditionNoUpdate* const fssncnu);

        virtual void process(AstForStatementStmtsNoConditionUpdate* const fssncu);

        virtual void process(AstForStatementVarsConditionNoUpdate* const fsvcnu);

        virtual void process(AstForStatementVarsConditionUpdate* const fsvcu);

        virtual void process(AstForStatementVarsNoConditionNoUpdate* const fsvncnu);

        virtual void process(AstForStatementVarsNoConditionUpdate* const fsvncu);

        virtual void process(AstFormalParameter* const fp);

        virtual void process(AstFormalParameterFinal* const fpf);

        virtual void process(AstFormalParameterList* const fpl);

        virtual void process(AstFormalParameterNonFinal* const fpnf);

        virtual void process(AstGoto* const g);

        virtual void process(AstGt* const g);

        virtual void process(AstGteq* const g);

        virtual void process(AstIdentifier* const i);

        virtual void process(AstIf* const i);

        virtual void process(AstIfThenElseStatement* const ites);

        virtual void process(AstIfThenStatement* const its);

        virtual void process(AstImplements* const i);

        virtual void process(AstImplementsInterfaceList* const iil);

        virtual void process(AstImport* const i);

        virtual void process(AstImportDeclaration* const id);

        virtual void process(AstImportDeclarationList* const idl);

        virtual void process(AstImportDeclarationOnDemand* const idod);

        virtual void process(AstImportDeclarationSingle* const ids);

        virtual void process(AstInstanceof* const i);

        virtual void process(AstInt* const i);

        virtual void process(AstIntegerLiteral* const il);

        virtual void process(AstIntegralType* const it);

        virtual void process(AstInterface* const i);

        virtual void process(AstInterfaceBody* const ib);

        virtual void process(AstInterfaceBodyDecls* const ibd);

        virtual void process(AstInterfaceBodyNoDecls* const ibnd);

        virtual void process(AstInterfaceDeclaration* const id);

        virtual void process(AstInterfaceDeclarationModsExtends* const idme);

        virtual void process(AstInterfaceDeclarationModsNoExtends* const idmne);

        virtual void process(AstInterfaceDeclarationNoModsExtends* const idnme);

        virtual void process(AstInterfaceDeclarationNoModsNoExtends* const idnmne);

        virtual void process(AstInterfaceMemberDeclarationList* const imdl);

        virtual void process(AstJavadocComment* const jc);

        virtual void process(AstLabeledStatement* const ls);

        virtual void process(AstLbrace* const l);

        virtual void process(AstLbracket* const l);

        virtual void process(AstLiteral* const l);

        virtual void process(AstLocalVariableDeclaration* const lvd);

        virtual void process(AstLocalVariableDeclarationFinal* const lvdf);

        virtual void process(AstLocalVariableDeclarationNonFinal* const lvdnf);

        virtual void process(AstLocalVariableDeclarationStatement* const lvds);

        virtual void process(AstLong* const l);

        virtual void process(AstLparen* const l);

        virtual void process(AstLshift* const l);

        virtual void process(AstLshifteq* const l);

        virtual void process(AstLt* const l);

        virtual void process(AstLteq* const l);

        virtual void process(AstMethodDeclaration* const md);

        virtual void process(AstMethodDeclarationBlock* const mdb);

        virtual void process(AstMethodDeclarationSemicolon* const mds);

        virtual void process(AstMethodDeclarator* const md);

        virtual void process(AstMethodDeclaratorNoArgs* const mdna);

        virtual void process(AstMethodDeclaratorWArgs* const mdWa);

        virtual void process(AstMethodHeader* const mh);

        virtual void process(AstMethodHeaderTypeModsNoThrows* const mhtmnt);

        virtual void process(AstMethodHeaderTypeModsThrows* const mhtmt);

        virtual void process(AstMethodHeaderTypeNoModsNoThrows* const mhtnmnt);

        virtual void process(AstMethodHeaderTypeNoModsThrows* const mhtnmt);

        virtual void process(AstMethodHeaderVoidModsNoThrows* const mhvmnt);

        virtual void process(AstMethodHeaderVoidModsThrows* const mhvmt);

        virtual void process(AstMethodHeaderVoidNoModsNoThrows* const mhvnmnt);

        virtual void process(AstMethodHeaderVoidNoModsThrows* const mhvnmt);

        virtual void process(AstMethodInvocation* const mi);

        virtual void process(AstMethodInvocationNameArgs* const mina);

        virtual void process(AstMethodInvocationNameNoArgs* const minna);

        virtual void process(AstMethodInvocationNameSuperArgs* const minsa);

        virtual void process(AstMethodInvocationNameSuperNoArgs* const minsna);

        virtual void process(AstMethodInvocationPrimaryArgs* const mipa);

        virtual void process(AstMethodInvocationPrimaryNoArgs* const mipna);

        virtual void process(AstMethodInvocationSuperArgs* const misa);

        virtual void process(AstMethodInvocationSuperNoArgs* const misna);

        virtual void process(AstMinus* const m);

        virtual void process(AstMinuseq* const m);

        virtual void process(AstMinusminus* const m);

        virtual void process(AstMod* const m);

        virtual void process(AstModeq* const m);

        virtual void process(AstModifierList* const ml);

        virtual void process(AstMult* const m);

        virtual void process(AstMulteq* const m);

        virtual void process(AstMultiplicativeExpression* const me);

        virtual void process(AstMultiplicativeExpressionDiv* const med);

        virtual void process(AstMultiplicativeExpressionMod* const mem);

        virtual void process(AstMultiplicativeExpressionMult* const mem);

        virtual void process(AstName* const n);

        virtual void process(AstNameDotClass* const ndc);

        virtual void process(AstNameDotThis* const ndt);

        virtual void process(AstNameList* const nl);

        virtual void process(AstNative* const n);

        virtual void process(AstNew* const n);

        virtual void process(AstNoncode* const n);

        virtual void process(AstNot* const n);

        virtual void process(AstNoteq* const n);

        virtual void process(AstNullLiteral* const nl);

        virtual void process(AstNumericType* const nt);

        virtual void process(AstOr* const o);

        virtual void process(AstOrExpression* const oe);

        virtual void process(AstOreq* const o);

        virtual void process(AstOror* const o);

        virtual void process(AstPackage* const p);

        virtual void process(AstPackageDeclaration* const pd);

        virtual void process(AstPlus* const p);

        virtual void process(AstPluseq* const p);

        virtual void process(AstPlusplus* const p);

        virtual void process(AstPostdecrementExpression* const pe);

        virtual void process(AstPostincrementExpression* const pe);

        virtual void process(AstPredecrementExpression* const pe);

        virtual void process(AstPreincrementExpression* const pe);

        virtual void process(AstPrimaryParenExpression* const ppe);

        virtual void process(AstPrimitiveDotClass* const pdc);

        virtual void process(AstPrimitiveType* const pt);

        virtual void process(AstPrivate* const p);

        virtual void process(AstProject* const p);

        virtual void process(AstProtected* const p);

        virtual void process(AstPublic* const p);

        virtual void process(AstQuestion* const q);

        virtual void process(AstRbrace* const r);

        virtual void process(AstRbracket* const r);

        virtual void process(AstRelationalExpression* const re);

        virtual void process(AstRelationalExpressionGt* const reg);

        virtual void process(AstRelationalExpressionGteq* const reg);

        virtual void process(AstRelationalExpressionInstanceof* const rei);

        virtual void process(AstRelationalExpressionLt* const rel);

        virtual void process(AstRelationalExpressionLteq* const rel);

        virtual void process(AstReturn* const r);

        virtual void process(AstReturnStatement* const rs);

        virtual void process(AstReturnStatementEmpty* const rse);

        virtual void process(AstReturnStatementExpr* const rse);

        virtual void process(AstRparen* const r);

        virtual void process(AstRshift* const r);

        virtual void process(AstRshifteq* const r);

        virtual void process(AstSemicolon* const s);

        virtual void process(AstShiftExpression* const se);

        virtual void process(AstShiftExpressionLshift* const sel);

        virtual void process(AstShiftExpressionRshift* const ser);

        virtual void process(AstShiftExpressionUrshift* const seu);

        virtual void process(AstShort* const s);

        virtual void process(AstStatementExpressionList* const sel);

        virtual void process(AstStatic* const s);

        virtual void process(AstStaticInitializer* const si);

        virtual void process(AstStrictfp* const s);

        virtual void process(AstStringLeaf* const sl);

        virtual void process(AstStringLiteral* const sl);

        virtual void process(AstSuper* const s);

        virtual void process(AstSwitch* const s);

        virtual void process(AstSwitchBlock* const sb);

        virtual void process(AstSwitchBlockEmpty* const sbe);

        virtual void process(AstSwitchBlockGroups* const sbg);

        virtual void process(AstSwitchBlockGroupsLabels* const sbgl);

        virtual void process(AstSwitchBlockLabels* const sbl);

        virtual void process(AstSwitchBlockStatementGroup* const sbsg);

        virtual void process(AstSwitchBlockStatementGroupList* const sbsgl);

        virtual void process(AstSwitchLabel* const sl);

        virtual void process(AstSwitchLabelCase* const slc);

        virtual void process(AstSwitchLabelDefault* const sld);

        virtual void process(AstSwitchLabelList* const sll);

        virtual void process(AstSwitchStatement* const ss);

        virtual void process(AstSynchronized* const s);

        virtual void process(AstSynchronizedStatement* const ss);

        virtual void process(AstTaggedComment* const tc);

        virtual void process(AstTaggedDescribedComment* const tdc);

        virtual void process(AstThis* const t);

        virtual void process(AstThrow* const t);

        virtual void process(AstThrowStatement* const ts);

        virtual void process(AstThrows* const t);

        virtual void process(AstThrowsNameList* const tnl);

        virtual void process(AstTransient* const t);

        virtual void process(AstTrueLiteral* const tl);

        virtual void process(AstTry* const t);

        virtual void process(AstTryStatement* const ts);

        virtual void process(AstTryStatementCatches* const tsc);

        virtual void process(AstTryStatementCatchesFinally* const tscf);

        virtual void process(AstTryStatementFinally* const tsf);

        virtual void process(AstTypeDeclarationList* const tdl);

        virtual void process(AstUnaryExpression* const ue);

        virtual void process(AstUnaryExpressionComp* const uec);

        virtual void process(AstUnaryExpressionMinus* const uem);

        virtual void process(AstUnaryExpressionNot* const uen);

        virtual void process(AstUnaryExpressionPlus* const uep);

        virtual void process(AstUrshift* const u);

        virtual void process(AstUrshifteq* const u);

        virtual void process(AstValue* const v);

        virtual void process(AstVariableDeclarator* const vd);

        virtual void process(AstVariableDeclaratorAssign* const vda);

        virtual void process(AstVariableDeclaratorId* const vdi);

        virtual void process(AstVariableDeclaratorIdDimensions* const vdid);

        virtual void process(AstVariableDeclaratorIdNoDimensions* const vdind);

        virtual void process(AstVariableDeclaratorList* const vdl);

        virtual void process(AstVariableDeclaratorNoAssign* const vdna);

        virtual void process(AstVariableInitializerList* const vil);

        virtual void process(AstVoid* const v);

        virtual void process(AstVoidDotClass* const vdc);

        virtual void process(AstVolatile* const v);

        virtual void process(AstWhile* const w);

        virtual void process(AstWhileStatement* const ws);

        virtual void process(AstXor* const x);

        virtual void process(AstXorExpression* const xe);

        virtual void process(AstXoreq* const x);

    };
}

#endif //! Processor_h
