#ifndef Reporter_h
#define Reporter_h

#ifndef ReportedError_h
#include "ReportedError.h"
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

#ifndef std_iostream
#define std_iostream
#include <iostream>
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

using namespace std;

namespace doctorj
{
    class AstItem;
    class Error;
    class File;

    class Reporter
    {
    public:
        Reporter(ostream& os);

        virtual ~Reporter();

        /**
         * Produces the error for the given item. Actually, this writes it into
         * the buffer. When the errors are written, they are sorted by line and
         * column.
         */
        virtual void report(AstItem* const item, const string& errorType, const string& msg);

        /**
         * Stores the error for reporting.
         */
        virtual void report(Error const* err);
        
        /**
         * Writes the errors.
         */
        void flush();

        /**
         * Disables the flushing functionality. That is, errors are written as
         * they come in.
         */
        void setUnbuffered();

    protected:

        /**
         * Produces the error for the given item in the appropriate format, as
         * defined by subclasses.
         */
        virtual void writeError(const ReportedError& err) = 0;

        ostream& stream();

        const vector<ReportedError>& getErrors() const;

        /**
         * Forcibly clears the errors, without being written. Compare to
         * <code>flush</code>.
         */
        virtual void clearErrors();

    private:

        ostream& os_;

        bool buffered_;

        vector<ReportedError> errors_;

    };
}

        
#endif //! Reporter_h
