#ifndef Check_h
#include "Check.h"
#endif

#ifndef ErrorRegistry_h
#include "ErrorRegistry.h"
#endif

#ifndef stdio_h
#include "stdio.h"
#endif

using namespace std;
using namespace doctorj;

Check::Check()
{
}

Check::Check(Reporter* const reporter) : reporter_(reporter)
{
}

Check::~Check()
{
}

void Check::describe(ostream& os) const
{
    os << id() << ": " << title() << endl;
    writeDescription(os);
}

Reporter* Check::reporter() const
{
    return reporter_;
}

string Check::id() const
{
    char idstr[10];
    sprintf(idstr, "%c%03d", category(), identifier());
    return idstr;
}

char Check::category() const
{
    return getErrorRegistry()->category();
}

int Check::identifier() const
{
    return getErrorRegistry()->identifier(title());
}

void Check::destroy() const
{
    delete this;
}
