#ifndef App_h
#define App_h

#ifndef Yagol_h
#include "Yagol.h"
#endif

#ifndef std_vector
#define std_vector
#include <vector>
#endif

#ifndef std_string
#define std_string
#include <string>
#endif

using namespace std;

namespace doctorj
{
    class AstProject;
    class ErrorDisableRuleOptionCallback;
    class ErrorEnableRuleOptionCallback;
    class ErrorRegistry;
    class ErrorSuppressionOptionCallback;
    class ErrorUnsuppressionOptionCallback;
    
    class App 
    {
    public:
        App(const string& name, const string& desc);

        virtual ~App();

        virtual void addOptions(yagol::AppOptionSet* const opts);

        /**
         * Sets up options.
         */
        virtual void buildOptions();

        /**
         * Reads the command line, shows the version information, displays error
         * codes, and executes.
         */
        virtual void run(int argc, char** argv);

        /**
         * Executes the project.
         */
        virtual void execute(AstProject* const proj) = 0;

        /**
         * Reads the command lines for the options and files.
         */
        virtual void readCommandLine(int argc, char** argv);

        /**
         * Displays the version information.
         */
        virtual void displayVersion();

        /**
         * Displays the version information, if requested.
         */
        virtual void handleVersion();

        /**
         * Provides detailed explanations of errors.
         */
        virtual void handleExplainedErrors();

        /**
         * Gets the unhandled arguments from the command line, parses them, and
         * executes the project.
         */
        virtual void processFiles();

        /**
         * Processes the debug options, if any.
         */
        virtual void handleDebugOptions();

        /**
         * Adds the context option, ensure that it is not already in the list of
         * options.
         */
        virtual void addContextOption();

    private:

        /**
         * The name of the application.
         */
        string name_;
        
        /**
         * The description of the application.
         */
        string description_;

        /**
         * The user's options.
         */
        yagol::AppOptionSet* options_;

        /**
         * Whether to show the version.
         */
        bool showVersion_;

        /**
         * The error codes to be explained.
         */
        vector<string> codes_;

        /**
         * Whether something meaningful was done.
         */
        bool acted_;

        /**
         * The suppression callback functor.
         */
        ErrorSuppressionOptionCallback* suppressionCB_;

        /**
         * The unsuppression callback functor.
         */
        ErrorUnsuppressionOptionCallback* unsuppressionCB_;

        /**
         * The disable-rule callback functor.
         */
        ErrorDisableRuleOptionCallback* disableCB_;

        /**
         * The enable-rule callback functor.
         */
        ErrorEnableRuleOptionCallback* enableCB_;
        
    };

}

#endif //! App_h
