/*
**  Copyright (c) 2007 Sendmail, Inc. and its suppliers.
**    All rights reserved.
*/

#ifndef _VBR_H_
#define _VBR_H_

#ifndef lint
static char vbr_h_id[] = "@(#)$Id: vbr.h,v 1.5 2007/06/07 07:53:01 msk Exp $";
#endif /* !lint */

/* headers */
#define	XVBRTYPEHEADER		"X-VBR-Type"
#define	XVBRCERTHEADER		"X-VBR-Certifier"

#define	VBR_ALL			"all"
#define	VBR_INFOHEADER		"VBR-Info"
#define	VBR_PREFIX		"_vouch"

/* prototypes */

/*
**  DKIM_VBR_GETHEADER -- generate and store the VBR-Info header
**
**  Parameters:
**  	dkim -- DKIM handle, created by dkim_sign() or dkim_verify()
**  	hdr -- header buffer
**  	len -- number of bytes available at "hdr"
**
**  Return value:
**  	DKIM_STAT_OK -- success
**  	DKIM_STAT_NORESOURCE -- "hdr" was too short
*/

extern DKIM_STAT
dkim_vbr_getheader __P((DKIM *, char *, size_t));

/*
**  DKIM_VBR_SETCERT -- store the VBR certifiers of this message
**
**  Parameters:
**  	dkim -- DKIM handle, created by dkim_sign() or dkim_verify()
**  	cert -- certifiers string
**
**  Return value:
**  	None (yet).
*/

extern void
dkim_vbr_setcert __P((DKIM *, char *));

/*
**  DKIM_VBR_SETTYPE -- store the VBR type of this message
**
**  Parameters:
**  	dkim -- DKIM handle, created by dkim_sign() or dkim_verify()
**  	type -- type string
**
**  Return value:
**  	None (yet).
*/

extern void
dkim_vbr_settype __P((DKIM *, char *));

/*
**  DKIM_VBR_TRUSTEDCERTS -- set list of trusted certifiers
**
**  Parameters:
**  	dkim -- DKIM handle, created by dkim_verify()
**  	certs -- NULL terminted vector of trusted certifier names
**
**  Return value:
**  	None (yet).
*/

extern void
dkim_vbr_trustedcerts __P((DKIM *, char **));

/*
**  DKIM_VBR_QUERY -- query the vouching servers for results
**
**  Parameters:
**  	dkim -- DKIM handle, created by dkim_verify()
**  	res -- result string (one of "fail", "pass"); returned
**  	cert -- name of the certifier that returned a "pass"; returned
**  	domain -- name of the sending domain; returned
**
**  Return value:
**  	DKIM_STAT_OK -- able to determine a result
**  	DKIM_STAT_INVALID -- dkim_vbr_trustedcerts(), dkim_vbr_settype() and
**  	                     dkim_vbr_setcert() were not all called
**  	DKIM_STAT_CANTVRFY -- DNS issue prevented resolution
**
**  Notes:
**  	- "pass" is the result if ANY certifier vouched for the message.
**  	- "res" is not modified if no result could be determined
**  	- "cert" and "domain" are not modified if a "pass" is not returned
**  	- there's no attempt to validate the values found
*/

extern DKIM_STAT
dkim_vbr_query __P((DKIM *, char **, char **, char **));

#endif /* _VBR_H_ */
