#ifndef _SCANTHREAD_H_INCLUDED
#define _SCANTHREAD_H_INCLUDED

#include <qthread.h>
#include <qvaluelist.h>
#include <qstring.h>

class List;
class ScanThread;
class DirViewItem;
class Cache;

class ScanItem
{
public:
	ScanItem();
	ScanItem(ScanThread *thread, List *owner, QString path, DirViewItem *item);
	ScanItem(const ScanItem& source);
	~ScanItem();
	ScanItem& operator= (const ScanItem& source);
	List *owner();
	QString path();
	ScanThread *thread();
	DirViewItem *item();
protected:
	ScanThread *s_thread;
	List *s_owner;
	QString s_path;
	DirViewItem *s_item;
};

class ScanThread : public QThread
{
public:
	ScanThread();
	~ScanThread();

	void addFile(List *owner, QString path, DirViewItem *item);
	void removeFile(List *owner, QString path);
	void removeFile(ScanItem it);
	void removeList(List *owner);
	void setSkip();
	void pause(bool yes);
protected:
	bool s_pause;
	bool s_skip;
	void run();
	void stop();
	QValueList<ScanItem> list;
	QWaitCondition listwait;
	QMutex listlock;
	bool s_stop;
	Cache *cache;
};

#endif
