#ifndef _BITMAPSLIDER_H_INCLUDED
#define _BITMAPSLIDER_H_INCLUDED

#include <qslider.h>

class BitmapSlider : public QSlider
{
Q_OBJECT

Q_PROPERTY(QPixmap backgroundPixmap READ backgroundPixmap WRITE setBackgroundPixmap)
Q_PROPERTY(QPixmap handlePixmap READ handlePixmap WRITE setHandlePixmap)
Q_PROPERTY(int handleOffset READ handleOffset WRITE setHandleOffset)

public:
	BitmapSlider(QWidget *parent, const char *name=0);
	BitmapSlider(Orientation, QWidget *parent, const char *name=0);
	BitmapSlider(int minValue, int maxValue, int pageStep, int value, Orientation, QWidget *parent, const char *name=0); 
	~BitmapSlider();

protected:
	QPixmap *s_backgroundPixmap;
	QPixmap *s_handlePixmap;
	int s_handleOffset;

	void commonConstruct();

public slots:
	void setBackgroundPixmap(const QPixmap& pix);
	QPixmap *backgroundPixmap() const;

	void setHandlePixmap(const QPixmap& pix);
	QPixmap *handlePixmap() const;

	void setHandleOffset(int len);
	int handleOffset() const;

protected slots:
	void paintEvent(QPaintEvent *e);
	void parentValueChanged(int val);
};

#endif
