/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include "pflpanel-background.xpm"
#include <bitmapbutton.h>
#include <bitmapslider.h>
#include "cfgfile.h"

void PflPanel::init()
{
    background=new QPixmap((const char **)pflpanel_background_xpm);
    mix_left=mix_right=pfl_left=pfl_right=0;
    left_player=right_player=0;
    talk_timer=new QTimer(this);
    talk_counter=0;
    mic_channel=0;
    connect(talk_timer, SIGNAL(timeout()), this, SLOT(talkTimeout()));
}


void PflPanel::destroy()
{
    delete talk_timer;
    if(left_player)
    {
	left_player->removePostFaderEffect(mix_left);
	left_player->removePostFaderEffect(talk_left);
    }
    if(right_player)
    {
	right_player->removePostFaderEffect(mix_right);
	right_player->removePostFaderEffect(talk_right);
    }
    if(mix_left)
	delete mix_left;
    if(mix_right)
	delete mix_right;
    if(talk_left)
	delete talk_left;
    if(talk_right)
	delete talk_right;
    delete background;
}



void PflPanel::setInfo( JackPlayer *lp, JackPlayer *rp, Effect *pfl_l, Effect *pfl_r )
{
    pfl_left=(MixEffect *)pfl_l;
    pfl_right=(MixEffect *)pfl_r;
    left_player=lp;
    right_player=rp;
    mix_left=new MixEffect;
    mix_right=new MixEffect;
    mix_left->left()->setPort(pfl_left->left()->port());
    mix_left->right()->setPort(pfl_left->right()->port());
    mix_right->left()->setPort(pfl_right->left()->port());
    mix_right->right()->setPort(pfl_right->right()->port());
    mix_left->setControl(2, 0.0);
    mix_right->setControl(2, 0.0);
    left_player->addPostFaderEffect(mix_left);
    right_player->addPostFaderEffect(mix_right);
    talk_left=new MixEffect;
    talk_right=new MixEffect;
    talk_left->left()->setPort(0);
    talk_left->right()->setPort(0);
    talk_right->left()->setPort(0);
    talk_right->right()->setPort(0);
    left_player->addPostFaderEffect(talk_left);
    right_player->addPostFaderEffect(talk_right);
}


void PflPanel::Level_valueChanged( int val)
{
    val=100-val;
    mix_left->setControl(1, (float)val/100.0);
    mix_right->setControl(1, (float)val/100.0);
    pfl_left->setControl(1, (float)val/100.0);
    pfl_right->setControl(1, (float)val/100.0);
}


void PflPanel::Crossfader_valueChanged( int val)
{
    pfl_left->setControl(2, (100.0-(float)val)/100.0);
    pfl_right->setControl(2, (100.0-(float)val)/100.0);
    mix_left->setControl(2, (float)val/100.0);
    mix_right->setControl(2, (float)val/100.0);
    emit crossfaderValueChanged(val);
}


void PflPanel::paintEvent( QPaintEvent *e )
{
    bitBlt(this, 0, 0, background);
}


void PflPanel::Talk_pressed()
{
    att_left_player=config->getValue("AttLeftPlayer", "1").toInt();
    att_right_player=config->getValue("AttRightPlayer", "1").toInt();
    att_line1=config->getValue("AttLine1", "1").toInt();
    att_line2=config->getValue("AttLine2", "1").toInt();
    
    if(talk_left && talk_right)
	talk_timer->start(15);
    if(mic_channel)
	mic_channel->setMicMixGain(1.0f);
}


void PflPanel::Talk_released()
{
    if(mic_channel)
	mic_channel->setMicMixGain(0.0f);
}


void PflPanel::talkTimeout()
{
    if(Talk->isOn())
    {
	if(talk_counter < 100)
	{
	    ++talk_counter;
	}
    }
    else
    {
	if(talk_counter > 0)
	{
	    --talk_counter;
	}
	if(!talk_counter)
	    talk_timer->stop();
    }
    float lev=1.0f-(float)talk_counter/100*((float)talk_level/100);
    if(att_left_player)
	talk_left->setControl(0, lev);
    if(att_right_player)
	talk_right->setControl(0, lev);
    if(line1 != mic_channel && att_line1)
	line1->setMicMixGain(lev);
    if(line2 != mic_channel && att_line2)
	line2->setMicMixGain(lev);
}


void PflPanel::setMicChannel( LinePanel *mc )
{
    if(mic_channel)
	mic_channel->setMicMixGain(1.0f);
    mic_channel=mc;
    if(mic_channel)
	mic_channel->setMicMixGain(0.0f);
}


void PflPanel::Talk_toggled( bool on)
{
    if(on)
	Talk_pressed();
    else
	Talk_released();
}
