#include "meter.h"
#include "meterset.h"
#include <qthread.h>

MeterSet::MeterSet()
{
	left_meter=0;
	right_meter=0;
	factor_left=1.0;
	factor_right=1.0;
}

MeterSet::MeterSet(Meter *left, Meter *right)
{
	left_meter=left;
	right_meter=right;
	factor_left=1.0;
	factor_right=1.0;
}

MeterSet::MeterSet(Meter *single)
{
	left_meter=single;
	right_meter=0;
	factor_left=1.0;
	factor_right=1.0;
}

MeterSet::~MeterSet()
{
}

void MeterSet::setMeters(Meter *left, Meter *right)
{
	left_meter=left;
	right_meter=right;
}

Meter *MeterSet::left()
{
	return left_meter;
}

Meter *MeterSet::right()
{
	return right_meter;
}

void MeterSet::setMeterValues(double l, double r, double lp, double rp)
{
	if(!right_meter)
	{
		if(!left_meter)
			return;
		left_meter->setValue((l+r)/2*factor_left, (lp+rp)/2*factor_left);
		return;
	}
	if(!left_meter)
		return;
	left_meter->setValue(l*factor_left, lp*factor_left);
	right_meter->setValue(r*factor_right, rp*factor_right);
}

void MeterSet::setMeterFactor(double fl, double fr)
{
	factor_left=fl;
	factor_right=fr;
}

void MeterSet::setPlayer(JackPlayer *player)
{
	my_player=player;
}

JackPlayer *MeterSet::player()
{
	return my_player;
}

void MeterSet::updateMeters()
{
	if(left_meter)
		QThread::postEvent(left_meter, new QPaintEvent(left_meter->rect(), false));
	if(right_meter)
		QThread::postEvent(right_meter, new QPaintEvent(right_meter->rect(), false));
}
