#include "lineprocessor.h"
#include "effect.h"

LineProcessor::LineProcessor(Port *in_left, Port *in_right, Port *out_left, Port *out_right)
{
	p_gain=1.0;
	p_in_left=in_left;
	p_in_right=in_right;
	p_out_left=out_left;
	p_out_right=out_right;
}

LineProcessor::~LineProcessor()
{
}

int LineProcessor::process(jack_nframes_t nsamples, void *arg)
{
	float *in_left, *out_left, *in_right, *out_right;

	in_left=(float *)p_in_left->buffer(nsamples);
	in_right=(float *)p_in_right->buffer(nsamples);
	out_left=(float *)p_out_left->buffer(nsamples);
	out_right=(float *)p_out_right->buffer(nsamples);

    QValueList<Effect *>::Iterator ei;
    for(ei=effects.begin();ei!=effects.end();++ei)
    {
        (*ei)->left()->setBuffer(in_left);
        (*ei)->right()->setBuffer(in_right);
        (*ei)->process(nsamples);
    }

    unsigned long i;
    for(i=0;i<nsamples;i++)
    {
        out_left[i]=in_left[i]*p_gain;
        out_right[i]=in_right[i]*p_gain;
    }

    for(ei=postfader_effects.begin();ei!=postfader_effects.end();++ei)
    {
        (*ei)->left()->setBuffer(out_left);
        (*ei)->right()->setBuffer(out_right);
        (*ei)->process(nsamples);
    }

	return 0;
}

void LineProcessor::setGain(float g)
{
	p_gain=g;
}

void LineProcessor::addEffect(Effect *e)
{
    if(effects.find(e) == effects.end())
        effects.append(e);
}

void LineProcessor::removeEffect(Effect *e)
{
    QValueList<Effect *>::Iterator it=effects.find(e);
    if(it == effects.end())
        return;
    effects.remove(it);
}

void LineProcessor::addPostFaderEffect(Effect *e)
{
    if(postfader_effects.find(e) == postfader_effects.end())
        postfader_effects.append(e);
}

void LineProcessor::removePostFaderEffect(Effect *e)
{
    QValueList<Effect *>::Iterator it=postfader_effects.find(e);
    if(it == postfader_effects.end())
        return;
    postfader_effects.remove(it);
}

