#include <qapplication.h>
#include <qwidget.h>
#include "djplay.h"
#include "mainwnd.h"
#include "recorder.h"
#include "playlist.h"
#include "frame.h"
#include "mixer.h"
#include "mixerpanel.h"
#include "pflpanel.h"
#include "linepanel.h"
#include "mixeffect.h"
#include <sys/signal.h>
#include "ladspaeffect.h"
#include "config.h"
#include "cfgfile.h"
#ifdef CONTROL_UNIT
#include <parapin.h>
#endif

#include <stdio.h>
#include <time.h>
#include <stdlib.h>

#ifndef __WIN__
#include <unistd.h>
#include <stdio.h>
#else
#include "windows.h"
#endif

#include <qwindowsstyle.h>

QApplication *app;
Playlist *playlist;
Frame *frame;
QWidget *mainmix;
Mixer *mixer;
int video_on=0;
char video_display[128]={""};
char out_pipe[2048]={""};
int out_relaunch=0;
Config *config;
int talk_level;
LinePanel *line1, *line2;
PflPanel *pfl;
MixerPanel *mix1=0, *mix2=0;

#define DISPLAYSIZE QSize(300, 180)
#define DISPLAYPOS QPoint(5, 5)

extern char *optarg;

int main(int argc, char *argv[])
{
	config=new Config("DJPlay");

	strcpy(out_pipe, config->getValue("BroadcastPipeline", ""));
	out_relaunch=config->getValue("BroadcastRelaunch", "0").toInt();
	talk_level=config->getValue("TalkLevel", "70").toInt();

	strcpy(video_display, config->getValue("VideoDisplay", ""));
	video_on=config->getValue("StartVideo", "0").toInt();

	if(config->getValue("MetadataFile", "") != "")
	{
		unlink(config->getValue("MetadataFile", ""));
	}

	int cc;

	while((cc=getopt(argc, argv, "NVD:Bb:")) != -1)
	{
		switch(cc)
		{
		case 'B':
			out_relaunch=1;
			break;
		case 'b':
			strcpy(out_pipe, optarg);
			break;
		case 'V':
			printf("Video on\n");
			video_on=1;
			break;
		case 'N':
			printf("Video off\n");
			video_on=0;
			break;
		case 'D':
			strcpy(video_display, optarg);
			break;
		}
	}
	srand(time(0));
	MainWnd *mainwnd;

#ifdef CONTROL_UNIT
	pin_init_user(0x378);
	setuid(getuid());
	setgid(getgid());
	seteuid(getuid());
	setegid(getgid());
	pin_input_mode(LP_DATA_PINS);
	pin_output_mode(LP_PIN01 | LP_PIN14);
	clear_pin(LP_PIN01);
	clear_pin(LP_PIN14);
#endif

	signal(SIGPIPE, SIG_IGN);
	QApplication a(argc, argv);
	app=&a;
	QWindowsStyle *style=new QWindowsStyle;
	a.setStyle(style);

	frame=new Frame(NULL, "DJPlayFrame", Qt::WType_TopLevel);
	frame->setCaption("DJPlay");
	frame->setFixedSize(1013,260);
	frame->move(config->getValue("MainX", "0").toInt(),
				config->getValue("MainY", "0").toInt());
	frame->show();

	mainwnd=new MainWnd(frame, "Player1", Qt::WResizeNoErase | Qt::WRepaintNoErase);
	mainwnd->setGeometry(0, 0, 400, 260);
	MainWnd *f1=mainwnd;

	a.connect(mainwnd, SIGNAL(windowClosed()), &a, SLOT(quit()));
	mainwnd=new MainWnd(frame, "Player2", Qt::WResizeNoErase | Qt::WRepaintNoErase);
	mainwnd->setGeometry(400, 0, 400, 260);
	f1->init_player(1);
	f1->show();
	mainwnd->init_player(2);
	mainwnd->show();
	MainWnd *f2=mainwnd;

	frame->setFrames(f1, f2);
	a.connect(frame, SIGNAL(windowClosed()), &a, SLOT(quit()));

	a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));

	Recorder *recorder=new Recorder(frame, "Recorder", Qt::WResizeNoErase | Qt::WRepaintNoErase);
	recorder->setGeometry(800, 0, 212, 260);
	recorder->show();

	playlist=new Playlist(NULL, "DJPlayPlaylist", Qt::WType_TopLevel);
	playlist->resize(829, 240);
	playlist->move(config->getValue("PlaylistX", "0").toInt(),
				   config->getValue("PlaylistY", "284").toInt());
//	playlist->setFixedSize(800,240);
	playlist->setCaption("Playlist");
	playlist->show();
	frame->setPlaylist(playlist);

	mixer=new Mixer(frame, "DJMixer", Qt::WType_TopLevel);
	mixer->setCaption("Crossfader");
	mixer->move(config->getValue("XFaderX", "841").toInt(),
				config->getValue("XFaderY", "284").toInt());

	mixer->show();
	frame->setMixer(mixer);

	mainmix=new QWidget(NULL, "DJPlayMainmix", Qt::WType_TopLevel);
	mainmix->resize(830, 193);
	mainmix->setFixedSize(830, 193);
	mainmix->move(config->getValue("MixerX", "0").toInt(),
				  config->getValue("MixerY", "548").toInt());
	mainmix->show();
	mainmix->setCaption("Mixer");

	mix1=new MixerPanel(mainmix, NULL, 0);
	mix1->move(0, 0);
	mix1->show();
	mix1->setMainWnd(1, f1);

	mix2=new MixerPanel(mainmix, NULL, 0);
	mix2->move(mix1->width(), 0);
	mix2->show();
	mix2->setMainWnd(2, f2);

	line1=new LinePanel(mainmix, NULL, 0);
	line1->move(mix1->width()*2, 0);
	line1->show();
	line1->setInfo(frame, frame->client(), ((MixEffect *)mix1->effect())->left()->port(), ((MixEffect *)mix1->effect())->right()->port(), 1);

	line2=new LinePanel(mainmix, NULL, 0);
	line2->move(mix1->width()*2+line1->width(), 0);
	line2->show();
	line2->setInfo(frame, frame->client(), ((MixEffect *)mix1->effect())->left()->port(), ((MixEffect *)mix1->effect())->right()->port(), 2);

	int mic=config->getValue("MicInput", "0").toInt();
	LinePanel *mic_channel=0;
	if(mic == 1)
		mic_channel=line1;
	if(mic == 2)
		mic_channel=line2;
	pfl=new PflPanel(mainmix, NULL, 0);
	pfl->move(mix1->width()*2+line1->width()*2, 0);
	pfl->show();
	pfl->setInfo(f1->get_player(), f2->get_player(), mix1->effect(), mix2->effect());
	pfl->setMicChannel(mic_channel);

	line1->connect(pfl, SIGNAL(crossfaderValueChanged(int)), line1, SLOT(pflCrossfaderValueChanged(int)));
	line2->connect(pfl, SIGNAL(crossfaderValueChanged(int)), line2, SLOT(pflCrossfaderValueChanged(int)));

	cc=a.exec();

	QString cf;
	cf.sprintf("%d", frame->pos().x());
	config->setValue("MainX", cf);
	cf.sprintf("%d", frame->pos().y());
	config->setValue("MainY", cf);
	cf.sprintf("%d", playlist->pos().x());
	config->setValue("PlaylistX", cf);
	cf.sprintf("%d", playlist->pos().y());
	config->setValue("PlaylistY", cf);
	cf.sprintf("%d", mixer->pos().x());
	config->setValue("XFaderX", cf);
	cf.sprintf("%d", mixer->pos().y());
	config->setValue("XFaderY", cf);
	cf.sprintf("%d", mainmix->pos().x());
	config->setValue("MixerX", cf);
	cf.sprintf("%d", mainmix->pos().y());
	config->setValue("MixerY", cf);

	delete config;

	delete playlist;
	delete mainmix;
	delete recorder;
	delete f1;
	delete f2;
	delete frame;
	return cc;
}
