#
# Exceptions.py - database exceptions
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: Exceptions.py 2273 2007-10-23 22:20:56Z vss $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.7/DITrack/DB/Exceptions.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

#
# Corrupted DB exceptions
#
class CorruptedDBError(Exception):
    message = "Database is corrupted"

class CorruptedDB_DuplicateUserError(CorruptedDBError):
    message = CorruptedDBError.message + ": duplicate user account entry"

class CorruptedDB_UnparseableCategoriesError(CorruptedDBError):
    message = CorruptedDBError.message \
        + ": unparseable categories configuration"

class CorruptedDB_UnparseableVersionsError(CorruptedDBError):
    message = CorruptedDBError.message \
        + ": unparseable version sets configuration"

class CorruptedDB_UnparseableListingFormatError(CorruptedDBError):
    message = CorruptedDBError.message \
        + ": unparseable listing format configuration"

class CorruptedDB_UnparseableFiltersError(CorruptedDBError):
    message = CorruptedDBError.message \
        + ": unparseable filter configuration"

#
# Other exceptions
#

class BadAttachmentNameError(Exception):
    message = "The attachment name can't be used in this transaction"

class BackendError(Exception):
    message = "Backend failed"
    def __init__(self, msg, backend_exception):
        self.message = msg
        self.backend_e = backend_exception

class DBIsLockedError(Exception):
    message = "Database is locked"

class FilterExpressionError(Exception):
    message = "Syntax error in filter expression"

class FilterIsPredefinedError(Exception):
    message = "This looks like a predefined filter name"

class InconsistentActionError(Exception):
    message = "The action would lead to database inconsistency"

class InvalidListingFormatError(Exception):
    message = "Invalid listing format"

class InvalidUserError(Exception):
    message = "Invalid username"

class InvalidVersionError(Exception):
    message = "Database format is not supported"

class IssueIdSyntaxError(Exception):
    message = "Invalid issue identifier syntax"

class NotDatabaseError(Exception):
    message = "Path specified is not an issue database root"

class NotDirectoryError(Exception):
    message = "Database path is not an [existing] directory"

#
# Not errors, but various conditions.
#
class NoDifferenceCondition(Exception):
    message = "No difference between passed entities"
