#
# remove.py - DITrack 'remove' command
#
# Copyright (c) 2007 The DITrack Project, www.ditrack.org.
#
# $Id: remove.py 1273 2007-02-12 06:44:42Z vss $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.5/DITrack/Command/remove.py $
#
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation 
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.
#

import string
import sys

# DITrack modules
import DITrack.Command.generic

class Handler(DITrack.Command.generic.Handler):
    canonical_name = "remove"
    description = """Remove local comments.
usage: %s ID...""" % canonical_name

    def run(self, opts, globals):

	self.check_options(opts)

	db = DITrack.Util.common.open_db(globals, opts)

        if len(opts.fixed) < 2:
            raise DITrack.Command.generic.SyntaxError

        issue_comments = {}

        for id in opts.fixed[1:]:

            issue_id, comment_id = DITrack.DB.entity_id_split(id)

            if comment_id is None:
                DITrack.Util.common.err(
                    "Comment identifier expected: '%s'" % id
                )

            if not db.is_valid_issue_name(comment_id):
                DITrack.Util.common.err(
                    "Non-local comment identifier: '%s'" % id
                )

            if issue_id not in issue_comments:
                issue_comments[issue_id] = {}

            issue_comments[issue_id][comment_id] = True

        # Sort the issue numbers that were mentioned in arguments
        issues = issue_comments.keys()
        issues.sort()

        for issue_id in issues:

            # This is (was) essentially a set of mentioned comment names.
            comments_to_remove = issue_comments[issue_id].keys()
            comments_to_remove.sort()
            comments_to_remove.reverse()

            issue = db[issue_id]

            # Fetch IDs only (hence x[0])
            existing_comments = [ x[0] for x in issue.comments(firm=False) ]
            existing_comments.sort
            existing_comments.reverse()

            for victim in comments_to_remove:

                if (not existing_comments) or (victim > existing_comments[0]):
                    DITrack.Util.common.err(
                        "No such comment: '%s.%s'" % (issue_id, victim)
                    )

                if victim < existing_comments[0]:
                    DITrack.Util.common.err(
                        "Can't remove '%s.%s': '%s.%s' is in the way"
                        % (issue_id, victim, issue_id, existing_comments[0])
                    )

                existing_comments.pop(0)

            # All correct. Remember the list.
            issue_comments[issue_id] = comments_to_remove

        # Now the removal loop itself.
        for issue_id in issues:
            for comment_id in issue_comments[issue_id]:
                db.remove_comment(issue_id, comment_id)
