#
# cat.py - DITrack 'cat' command
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: cat.py 1326 2007-02-26 03:46:34Z vss $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.5/DITrack/Command/cat.py $
#
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation 
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.
#

import sys

# DITrack modules
import DITrack.Command.generic

class Handler(DITrack.Command.generic.Handler):
    canonical_name = "cat"
    description = """Dump text/headers of an issue or its part.
usage: %s ISSUEID
   or: %s ISSUEID.COMMENTID""" % (canonical_name, canonical_name)

    def run(self, opts, globals):
        self.check_options(opts)

        if len(opts.fixed) != 2:
            self.print_help(globals)
            sys.exit(1)

        headers_only = opts.var.has_key("headers_only") \
            and opts.var["headers_only"]

        db = DITrack.Util.common.open_db(globals, opts)

        # XXX: add a flag to entity_id_split() to err out?
        try:
            issue_id, comment_id = DITrack.DB.entity_id_split(opts.fixed[1])
        except ValueError:
            DITrack.Util.common.err(
                "Invalid identifier: '%s'" % opts.fixed[1],
                fatal=True)

        if headers_only and (comment_id is None):
            # dt cat --headers-only 1
            #   is a shortcut for
            # dt cat --headers-only 1.0
            comment_id = "0"

        issue = db.issue_by_id(issue_id)

        match = False

        if (comment_id is None) or (comment_id == "0"):
            match = True
            sys.stdout.write("Issue: %s\n" % issue_id)
            issue.write_info()

            if not headers_only:
                sys.stdout.write("\n")

        first = True
        for id, comment in issue.comments():
            if (comment_id is None) or (id == comment_id):

                match = True

                if not first:
                    print "Comment: %s" % id

                comment.write(
		    headers_only=headers_only,
		    display_headers=(
			(not first) 
			or (comment_id and (comment_id != "0"))
		    )
		)

                if not headers_only: print

            if comment_id is None:
                print globals.text_delimiter

            first = False

        if not match:
            DITrack.Util.common.err(
                "No such entity: '%s.%s'" % (issue_id, comment_id),
                fatal=True)
