#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# displayconfig.py - description                                          #
# ------------------------------                                          #
# begin     : Fri Mar 02 2007                                             #
# copyright : (C) 2007 Canonical
# email     : michael.vogt@ubuntu.com                                     #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

import string
import os
import select
import sys
import csv
import time
import signal
import shutil

import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import gobject
from displayconfiggtk.SimpleGladeApp import SimpleGladeApp


from displayconfig.displayconfigcommon import _findXorgConfig, testX
from displayconfig.displayconfigabstraction import *
from displayconfig.displayconfigabstraction import Screen, GfxCard, XSetup

from gettext import gettext as _

def get_screen_name(screen):
    screen_name = _("Unkown")
    if screen.getMonitorModel():
        screen_name = screen.getMonitorModel().getName()
    if screen.getMonitorAspect()==ModeLine.ASPECT_16_9:
        screen_name = "%s %s" % (screen_name, _("(widescreen)"))
    return screen_name

class DeviceChooser(gtk.Button):
    def __init__(self, device=None):
        gtk.Button.__init__(self)
        # get some device specific information
        if isinstance(device, Screen):
            icon_name = "video-display"
            self.model_name = get_screen_name(device)
        elif isinstance(device, GfxCard):
            icon_name = "video-card"
            self.model_name = device.detected_model
            if device.isProprietaryDriver():
                self.model_name = device.getGfxCardModel().getProprietaryDriver()
            else:
                self.model_name = device.getGfxCardModel().getDriver()
        img = gtk.Image()
        img.set_from_icon_name(icon_name, gtk.ICON_SIZE_BUTTON)
        hbox = gtk.HBox()
        hbox.set_spacing(6)
        hbox.pack_start(gtk.Label(str="%s" % self.model_name),
                        expand=True, fill=True)
        hbox.pack_start(gtk.VSeparator(),
                        expand=False, fill=False)
        hbox.pack_start(img, expand=False, fill=True)
        self.add(hbox)

class GfxCardFrame(gtk.Frame):
    """A frame widget that provides information about a corresponding
       graphics card and that allows to configure the driver and
       connected monitors."""
    def __init__(self, app, card, config_handler):
        class DetailsLabel(gtk.Label):
            """A label widget that is used in the details table."""
            def __init__(self, str=""):
                gtk.Label.__init__(self, str)
                self.set_alignment(0, 0.5)
        gtk.Frame.__init__(self)
        self.app = app
        self.card = card
        self.card_model = card.getGfxCardModel()
        self.set_shadow_type(gtk.SHADOW_NONE)
        label_frame = gtk.Label()
        label_frame.set_markup("<b>Graphics card (%s)</b>" % \
                               self.card.detected_model)
        self.set_label_widget(label_frame)
        self.alignment = gtk.Alignment()
        self.alignment.set_padding(6, 0, 12, 0)
        self.alignment.set(0, 0, 1, 0)
        self.details = gtk.Table(1, 2, False)
        self.details.set_row_spacings(6)
        self.details.set_col_spacings(12)
        # Add driver widgets
        if self.card_model is not None:
            self.details.attach(DetailsLabel(str=_("Driver:")),
                                0, 1, 0, 1, 
                                xoptions=gtk.FILL, yoptions=gtk.FILL)
            button = DeviceChooser(self.card)
            button.connect("clicked", config_handler, self.card)
            self.details.attach(button, 1, 2, 0, 1, 
                                xoptions=gtk.FILL, yoptions=gtk.EXPAND)

        # Add screen widgets
        i = 0
        for screen in self.card.getScreens():
            self.details.attach(DetailsLabel(str=_("Screen #%i:" % (i+1))),
                                0, 1, i+1, i+2,
                                xoptions=gtk.FILL, yoptions=gtk.FILL)
            button_screen = DeviceChooser(screen)
            button_screen.connect("clicked", config_handler, screen)
            self.details.attach(button_screen, 1, 2, i+1, i+2,
                                xoptions=gtk.FILL, yoptions=gtk.EXPAND)
            i =+ 1
        self.alignment.add(self.details)
        self.add(self.alignment)
        # Show what we have!
        self.show_all()

# vim:ts=4:sw=4:et
