/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio.component.dialogs;

import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.component.ExtendedHTMLDocument;
import de.xeinfach.kafenio.component.ExtendedHTMLEditorKit;
import de.xeinfach.kafenio.component.dialogs.ImageDialogControls;
import de.xeinfach.kafenio.component.dialogs.SimpleInfoDialog;
import de.xeinfach.kafenio.util.LeanLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTML;

public class ImageDialog
extends JDialog
implements ActionListener {
    private static final String ACTION_INSERT = "insert";
    private static final String ACTION_PREVIEW = "preview";
    private static final String ACTION_CANCEL = "cancel";
    private static LeanLogger log = new LeanLogger("ImageDialog.class");
    private KafenioPanel kafenio;
    private ExtendedHTMLEditorKit htmlKit;
    private ExtendedHTMLDocument htmlDoc;
    private JEditorPane previewPane;
    private Vector names;
    private Vector images;
    private String previewImage;
    private String selectedImage;
    private JList imageList;
    private JTextField imageAltText;
    private ImageDialogControls controls;

    public ImageDialog(KafenioPanel kafenioPanel, Vector vector, Vector vector2) {
        super(kafenioPanel.getFrame(), kafenioPanel.getTranslation("InsertServerImageDialogTitle"), true);
        this.kafenio = kafenioPanel;
        this.names = vector;
        this.images = vector2;
        this.selectedImage = "";
        this.initComponents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (actionEvent.getActionCommand().equals(ACTION_INSERT)) {
            ListSelectionModel listSelectionModel = this.imageList.getSelectionModel();
            if (listSelectionModel.isSelectionEmpty()) {
                SimpleInfoDialog simpleInfoDialog = new SimpleInfoDialog(this.kafenio, this.getString("Error"), true, this.getString("InsertImageDialog_NoImageSelectedText"), 0);
                this.imageList.requestFocus();
            } else {
                this.updatePreview();
                this.selectedImage = this.controls.getHtmlImgString(this.imageAltText.getText(), this.previewImage);
                this.hide();
            }
        } else if (actionEvent.getActionCommand().equals(ACTION_CANCEL)) {
            this.hide();
        }
    }

    private void initComponents() {
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.imageList = new JList(this.names);
        this.imageList.setSelectionMode(0);
        this.imageList.clearSelection();
        ListSelectionModel listSelectionModel = this.imageList.getSelectionModel();
        this.previewPane = new JEditorPane();
        this.previewPane.setEditable(false);
        this.htmlKit = new ExtendedHTMLEditorKit();
        this.htmlKit.setDefaultCursor(new Cursor(2));
        this.htmlDoc = this.getDefaultDocument();
        this.previewPane.setCaretPosition(0);
        this.previewPane.setEditorKit(this.htmlKit);
        this.previewPane.setDocument(this.htmlDoc);
        this.previewPane.setMargin(new Insets(4, 4, 4, 4));
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ImageDialog.this.loadSelectedPreviewImage();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.imageList);
        jScrollPane.setPreferredSize(new Dimension(200, 250));
        jScrollPane.setMaximumSize(new Dimension(200, 250));
        jScrollPane.setAlignmentX(0.0f);
        JScrollPane jScrollPane2 = new JScrollPane(this.previewPane);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane2.setPreferredSize(new Dimension(250, 250));
        JSplitPane jSplitPane = new JSplitPane(1, true, jScrollPane, jScrollPane2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jSplitPane, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getString("InsertImageDialogServerImagesBorder")));
        JLabel jLabel = new JLabel(this.getString("InsertImageDialogAlternateTextField"), 2);
        this.imageAltText = new JTextField("");
        this.imageAltText.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(border);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.imageAltText, "Center");
        JPanel jPanel3 = new JPanel(new GridLayout());
        jPanel3.add(jPanel2);
        this.controls = new ImageDialogControls(this);
        JButton jButton = new JButton(this.getString("InsertImageDialogInsertButton"));
        jButton.setActionCommand(ACTION_INSERT);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(this.getString("DialogCancel"));
        jButton2.setActionCommand(ACTION_CANCEL);
        jButton2.addActionListener(this);
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 5, 0));
        jPanel4.setBorder(border);
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel, "Center");
        jPanel5.add((Component)this.controls, "East");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(jPanel5);
        this.getContentPane().add(jPanel3);
        this.getContentPane().add(jPanel4);
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setVisible(true);
    }

    private void loadSelectedPreviewImage() {
        ListSelectionModel listSelectionModel = this.imageList.getSelectionModel();
        if (!listSelectionModel.isSelectionEmpty()) {
            this.previewImage = (String)this.images.get(listSelectionModel.getMinSelectionIndex());
            try {
                log.debug("trying to display preview image: " + this.previewImage);
                ImageIcon imageIcon = new ImageIcon(new URL(this.previewImage));
                this.controls.setNewImage(imageIcon.getIconWidth(), imageIcon.getIconHeight());
            }
            catch (Exception exception) {
                log.error("Exception previewing image " + exception.fillInStackTrace());
            }
        }
    }

    public String getSelectedImage() {
        return this.selectedImage;
    }

    public void updatePreview() {
        try {
            this.htmlDoc = this.getDefaultDocument();
            this.previewPane.setDocument(this.htmlDoc);
            String string = this.controls.getHtmlImgString(this.imageAltText.getText(), this.previewImage);
            this.htmlKit.insertHTML(this.htmlDoc, 0, string, 0, 0, HTML.Tag.IMG);
            this.validate();
        }
        catch (Exception exception) {
            log.error("an error ocurred while updating the preview image: " + exception.fillInStackTrace());
        }
    }

    private ExtendedHTMLDocument getDefaultDocument() {
        try {
            return (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument(new URL(this.kafenio.getConfig().getCodeBase()));
        }
        catch (Exception exception) {
            return (ExtendedHTMLDocument)this.htmlKit.createDefaultDocument();
        }
    }

    public String getString(String string) {
        return this.kafenio.getTranslation(string);
    }
}

