/*
 * File: about.c
 *
 * Copyright (C) 1997 Raph Levien <raph@acm.org>
 * Copyright (C) 1999, 2001 Jorge Arellano Cid <jcid@dillo.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <config.h>
#include "Url.h"
#include "../nav.h"
#include "../web.h"

typedef struct _SplashInfo SplashInfo_t;

struct _SplashInfo {
   gint FD_Read;
   gint FD_Write;
};


/*
 * HTML text for startup screen
 */
static char *Splash=
"Content-type: text/html\n"
"\n"
"<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'>\n"
"<html>\n"
"<head>\n"
"<title>Splash screen for dillo-" VERSION "</title>\n"
"</head>\n"
"<body bgcolor='#778899' text='#000000' link='#000000' vlink='#000000'>\n"
"\n"
"\n"
"<!--                          -->\n"
"<!--   the head of the page   -->\n"
"<!--                          -->\n"
"\n"
"<table width='100%' border='0' cellspacing='1' cellpadding='3'>\n"
" <tr><td>\n"
"   <table border='1' cellspacing='1' cellpadding='0'>\n"
"    <tr>\n"
"    <td bgcolor='#000000'>\n"
"     <table width='100%' border='0' bgcolor='#ffffff'>\n"
"     <tr>\n"
"       <td valign='top' align='left'>\n"
"         <h1>&nbsp;Welcome to Dillo " VERSION "&nbsp;</h1>\n"
"       </td>\n"
"     </tr>\n"
"     </table>\n"
"    </tr>\n"
"   </table>\n"
" </td></tr>\n"
"</table>\n"
"\n"
"<!-- a small horizontal spacer -->\n"
"<br>\n"
"\n"
"\n"
"<!--                                   -->\n"
"<!-- the main layout table, definition -->\n"
"<!--                                   -->\n"
"\n"
"<table width='100%' border='0' cellspacing='0' cellpadding='0'>\n"
"<tr><td valign='top' width='150' align='center'>\n"
"\n"
"\n"
"<!--                        -->\n"
"<!--   The navigation bar   -->\n"
"<!--                        -->\n"
"\n"
"<table border='0' cellspacing='0' cellpadding='0' width='140' bgcolor='#000000'>\n"
"<tr>\n"
"  <td>\n"
"    <table width='100%' border='0' cellspacing='1' cellpadding='3'>\n"
"    <tr>\n"
"      <td colspan='1' bgcolor='#CCCCCC'>\n"
"        Dillo\n"
"      </td>\n"
"    </tr>\n"
"    <tr>\n"
"      <td bgcolor='#FFFFFF'>\n"
"        <table border='0' cellspacing='0' cellpadding='5'><tr><td>\n"
"        <table border='0' cellspacing='0' cellpadding='2'><tr>\n"
"        <td></td>\n"
"        <td>\n"
"         <a href='http://www.dillo.org/dillo-help.html'>\n"
"         Help</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.dillo.org/'>Home</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.dillo.org/funding/objectives.html'>\n"
"         Objectives</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.dillo.org/ChangeLog.html'>\n"
"         ChangeLog</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.dillo.org/interview.html'>\n"
"           Interview</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.dillo.org/D_authors.html'>\n"
"         Authors</a></td>\n"
"        </tr></table>\n"
"        </td></tr></table>\n"
"      </td>\n"
"    </tr>\n"
"    </table>\n"
"  </td>\n"
"</tr>\n"
"</table>\n"
"\n"
"<!-- a small horizontal spacer -->\n"
"<br>\n"
"\n"
"<table border='0' cellspacing='0' cellpadding='0' width='140' bgcolor='#000000'>\n"
"<tr>\n"
"  <td>\n"
"    <table width='100%' border='0' cellspacing='1' cellpadding='3'>\n"
"    <tr>\n"
"      <td colspan='1' bgcolor='#CCCCCC'>\n"
"        Magazines\n"
"      </td>\n"
"    </tr>\n"
"    <tr>\n"
"      <td bgcolor='#FFFFFF'>\n"
"        <table border='0' cellspacing='0' cellpadding='5'><tr><td>\n"
"        <table border='0' cellpadding='2'><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://lwn.net'>LWN</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://slashdot.org/'>Slashdot</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.kuro5hin.org/?op=section;section=__all__'>KuroShin</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.nexusmagazine.com'>Nexus&nbsp;M.</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.gnu-darwin.org/update.html'>Monster News</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.thejemreport.com/index.php'>TheJemReport</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.theregister.co.uk/index.html'>The Register</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.infoanarchy.org/'>InfoAnarchy</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td>\n"
"         <a href='http://www.linuxforkids.org'>Linux4Kids</a></td>\n"
"        </tr></table>\n"
"        </td></tr></table>\n"
"      </td>\n"
"    </tr>\n"
"    </table>\n"
"  </td>\n"
"</tr>\n"
"</table>\n"
"\n"
"<!-- a small horizontal spacer -->\n"
"<br>\n"
"\n"
"<table border='0' cellspacing='0' cellpadding='0' width='140' bgcolor='#000000'>\n"
"<tr>\n"
"  <td>\n"
"    <table width='100%' border='0' cellspacing='1' cellpadding='3'>\n"
"    <tr>\n"
"      <td colspan='1' bgcolor='#CCCCCC'>\n"
"        Additional Stuff\n"
"      </td>\n"
"    </tr>\n"
"    <tr>\n"
"      <td bgcolor='#FFFFFF'>\n"
"        <table border='0' cellspacing='0' cellpadding='5'><tr><td>\n"
"        <table border='0' cellpadding='2'><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td><a href='http://www.google.com/'>Google</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td><a href='http://www.wikipedia.org/'>Wikipedia</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td><a href='http://www.gutenberg.org/'>P. Gutenberg</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td><a href='http://freshmeat.net/'>FreshMeat</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td><a href='http://www.gnu.org/gnu/thegnuproject.html'>GNU\n"
"         project</a></td>\n"
"        </tr><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td><a href='http://www.linuxfund.org/'>LinuxFund</a></td>\n"
"        </tr></table>\n"
"        </td></tr></table>\n"
"      </td>\n"
"    </tr>\n"
"    </table>\n"
"  </td>\n"
"</tr>\n"
"</table>\n"
"\n"
"<!-- a small horizontal spacer -->\n"
"<br>\n"
"\n"
"<table border='0' cellspacing='0' cellpadding='0' width='140' bgcolor='#000000'>\n"
"<tr>\n"
"  <td>\n"
"    <table width='100%' border='0' cellspacing='1' cellpadding='3'>\n"
"    <tr>\n"
"      <td colspan='1' bgcolor='#CCCCCC'>\n"
"        Essential Reading\n"
"      </td>\n"
"    </tr>\n"
"    <tr>\n"
"      <td bgcolor='#FFFFFF'>\n"
"        <table border='0' cellspacing='0' cellpadding='5'><tr><td>\n"
"        <table border='0' cellpadding='2'><tr>\n"
"        <td>&nbsp;&nbsp;</td>\n"
"        <td><a href='http://www.violence.de'>Peace&amp;Violence</a></td>\n"
"        </tr></table>\n"
"        </td></tr></table>\n"
"      </td>\n"
"    </tr>\n"
"    </table>\n"
"  </td>\n"
"</tr>\n"
"</table>\n"
"<!-- a small horizontal spacer -->\n"
"<table border='0' width='100%' cellpadding='0' cellspacing='0'><tr><td height='10'></td></tr></table>\n"
"\n"
"\n"
"\n"
"<!--                                                -->\n"
"<!-- the main layout table, a small vertical spacer -->\n"
"<!--                                                -->\n"
"\n"
"</td><td width='20'></td><td valign='top'>\n"
"\n"
"\n"
"<!--                           -->\n"
"<!--   Main Part of the page   -->\n"
"<!--                           -->\n"
"\n"
"<table border='0' cellpadding='0' cellspacing='0' align='center' bgcolor='#000000' width='100%'><tr><td>\n"
"<table border='0' cellpadding='5' cellspacing='1' width='100%'>\n"
"<tr>\n"
"  <td bgcolor='#CCCCCC'>\n"
"    <h4>Free Software</h4>\n"
"  </td>\n"
"</tr><tr>\n"
"  <td bgcolor='#FFFFFF'>\n"
"    <table border='0' cellspacing='0' cellpadding='5'><tr><td>\n"
" <p>\n"
" Dillo is Free Software in the terms of the GPL.\n"
" This means you have four basic freedoms:\n"
" <ul>\n"
"  <li>Freedom to use the program any way you see fit.\n"
"  <li>Freedom to study and modify the source code.\n"
"  <li>Freedom to make backup copies.\n"
"  <li>Freedom to redistribute it.\n"
" </ul>\n"
" The\n"
"<a href='http://www.gnu.org/licenses/gpl.html'>GPL</a>\n"
" is the legal mechanism that gives you these freedoms.\n"
"It also protects them from being taken away: any derivative work\n"
"based on the program must be under the GPL.\n"
" <br>\n"
"    </td></tr></table>\n"
"  </td>\n"
"</tr>\n"
"</table>\n"
"</td></tr></table>\n"
"\n"
"<!-- a small horizontal spacer -->\n"
"<br>\n"
"\n"
"<table border='0' cellpadding='0' cellspacing='0' align='center' bgcolor='#000000' width='100%'><tr><td>\n"
"<table border='0' cellpadding='5' cellspacing='1' width='100%'>\n"
"<tr>\n"
"  <td bgcolor='#CCCCCC'>\n"
"    <h4>Release overview</h4>\n"
"    14 May 2004\n"
"  </td>\n"
"</tr><tr>\n"
"  <td bgcolor='#FFFFFF'>\n"
"    <table border='0' cellspacing='0' cellpadding='5'>\n"
"    <tr>\n"
"     <td>\n"
"\n"
"<p>\n"
"The new dillo-0.8.1 comes with an improved parser. The <em>block/inline</em>"
"\ncontainer model information is now an essential part of the parser.\n"
"<p>\n"
"This both improves bug detection in the bug-meter, and the rendering\n"
"of HTML pages!\n"
"<p>\n"
"Dillo now is able to detect and offer a download dialog when a clicked URL\n"
"is not viewable.\n"
"<p>\n"
"Several glitches of the previous release were also fixed\n"
"rounding up this new version, which is no longer alpha but\n"
"<em>very stable beta</em>.\n"
"<p>\n"
"Remember that dillo project uses a release model where every new\n"
"browser shall be better than the former.\n"
"<EM>Keep up with the latest one!</EM>\n"
"\n"
"     </td>\n"
"    </tr></table>\n"
"  </td>\n"
"</tr>\n"
"</table>\n"
"</td></tr></table>\n"
"\n"
"<!-- a small horizontal spacer -->\n"
"<br>\n"
"\n"
"<table border='0' cellpadding='0' cellspacing='0' align='center' bgcolor='#000000' width='100%'><tr><td>\n"
"<table border='0' cellpadding='5' cellspacing='1' width='100%'>\n"
"<tr>\n"
"  <td bgcolor='#CCCCCC'>\n"
"    <h4>ChangeLog highlights</h4>\n"
"    (Extracted from the\n"
"    <a href='http://www.dillo.org/ChangeLog.html'>full\n"
"    ChangeLog</a>)\n"
"  </td>\n"
"</tr><tr>\n"
"  <td bgcolor='#FFFFFF'>\n"
"    <table border='0' cellspacing='0' cellpadding='5'>\n"
"    <tr>\n"
"     <td>\n"
"<ul>\n"
"<li>Added container|inline model information to the HTML element table, and\n"
"    made the bug-meter and the parser aware of it. This both improves bug\n"
"    detection and rendering.\n"
"<li>Added proxy authentication support through the \"http_proxyuser\"\n"
"    option in dillorc (the password is asked at run time).\n"
"<li>Fixed a slippery bug with certain interlaced gif images.\n"
"<li>Fixed configure.in so pthreads are only linked where needed.\n"
"<li>Added a test for socklen_t in configure.in.\n"
"<li>Fixed The ladder effect with lists.\n"
"<li>Made the bug-meter detect tags lacking a closing '&gt;'.\n"
"<li>Made the bug-meter detect excluded inline elements from &lt;PRE&gt;.\n"
"<li>Fixed the URL resolver handling of the \"//\" sequence in &lt;path&gt;.\n"
"<li>Fixed the downloads dpi to handle both new savenames and"
"    target directory.\n"
"<li>Made dillo recognize unhandled MIME types, and offer a download dialog!\n"
"</ul>\n"
"     </td>\n"
"    </tr></table>\n"
"  </td>\n"
"</tr>\n"
"</table>\n"
"</td></tr></table>\n"
"\n"
"<!-- a small horizontal spacer -->\n"
"<br>\n"
"\n"
"<table border='0' cellpadding='0' cellspacing='0' align='center' bgcolor='#000000' width='100%'><tr><td>\n"
"<table border='0' cellpadding='5' cellspacing='1' width='100%'>\n"
"<tr>\n"
"  <td bgcolor='#CCCCCC'>\n"
"    <h4>Notes</h4>\n"
"  </td>\n"
"</tr><tr>\n"
"  <td bgcolor='#FFFFFF'>\n"
"    <table border='0' cellspacing='0' cellpadding='5'>\n"
"    <tr>\n"
"     <td>\n"
" <ul>\n"
"   <li> There's a\n"
"     <a href='http://www.dillo.org/dillorc'>dillorc</a>\n"
"     (readable  config)  file within the tarball; It is well commented\n"
"     and  has  plenty  of  options to customize dillo, so <STRONG>copy\n"
"     it</STRONG>  to  your  <STRONG>~/.dillo/</STRONG>  directory, and\n"
"     modify to your taste.\n"
"   <li> There's documentation for developers in the <CODE>/doc</CODE>\n"
"     dir  within  the  tarball;  you can find directions on everything\n"
"     else at the home page.\n"
"   <li> Dillo has context sensitive menus using the\n"
"     right mouse button (available on pages, links, images,\n"
"     the Back and Forward buttons, and bug meter).\n"
"   <li> Dillo behaves very nicely when browsing local files, images, and HTML.\n"
"     It's also very good for Internet searching (try Google!).\n"
"   <li> This release is mainly intended <strong>for developers</strong>\n"
"        and <em>advanced users</em>\n"
"   <li> Frames, Java and Javascript are not supported.\n"
" </ul>\n"
" <br>\n"
"     </td>\n"
"    </tr></table>\n"
"  </td>\n"
"</tr>\n"
"</table>\n"
"</td></tr></table>\n"
"\n"
"<!-- a small horizontal spacer -->\n"
"<table border='0' width='100%' cellpadding='0' cellspacing='0'><tr><td height='10'></td></tr></table>\n"
"\n"
"\n"
"<!--                                                -->\n"
"<!-- the main layout table, a small vertical spacer -->\n"
"<!--                                                -->\n"
"\n"
"</td><td width='20'></td>\n"
"\n"
"\n"
"\n"
"<!--                             -->\n"
"<!--   The right column (info)   -->\n"
"<!--                             -->\n"
"<td valign='top' align='center'>\n"
"</td>\n"
"\n"
"\n"
"<!--                              -->\n"
"<!-- end of the main layout table -->\n"
"<!--                              -->\n"
"\n"
"</tr>\n"
"</table>\n"
"\n"
"<!--               -->\n"
"<!--   footnotes   -->\n"
"<!--               -->\n"
"\n"
"<br><br><center>\n"
"<hr size='2'>\n"
"<hr size='2'>\n"
"</center>\n"
"</body>\n"
"</html>\n";



/*
 * Send the splash screen through the IO using a pipe.
 */
static gint About_send_splash(ChainLink *Info, DilloUrl *Url)
{
   gint SplashPipe[2];
   IOData_t *io1;
   SplashInfo_t *SpInfo;

   if (pipe(SplashPipe))
      return -1;

   SpInfo = g_new(SplashInfo_t, 1);
   SpInfo->FD_Read  = SplashPipe[0];
   SpInfo->FD_Write = SplashPipe[1];
   Info->LocalKey = SpInfo;

   /* send splash */
   io1 = a_IO_new(IOWrite, SpInfo->FD_Write);
   a_IO_set_buf(io1, Splash, strlen(Splash));
   io1->Flags |= (IOFlag_ForceClose + IOFlag_SingleWrite);
   a_Chain_link_new(Info, a_About_ccc, BCK, a_IO_ccc, 1, 1);
   a_Chain_bcb(OpStart, Info, io1, NULL);
   a_Chain_bcb(OpSend, Info, io1, NULL);

   /* Tell the cache to receive answer */
   a_Chain_fcb(OpSend, Info, &SpInfo->FD_Read, NULL);
   return SpInfo->FD_Read;
}

/*
 * Push the right URL for each supported "about"
 * ( Data1 = Requested URL; Data2 = Web structure )
 */
static gint About_get(ChainLink *Info, void *Data1, void *Data2)
{
   char *loc;
   const char *tail;
   DilloUrl *Url = Data1;
   DilloWeb *web = Data2;
   DilloUrl *LocUrl;

   tail = URL_PATH(Url);

   if (!strcmp(tail, "splash")) {
      return About_send_splash(Info, Url);
   }

   if (!strcmp(tail, "jwz"))
      loc = "http://www.jwz.org/";
   else if (!strcmp(tail, "raph"))
      loc = "http://www.levien.com/";
   else if (!strcmp(tail, "yosh"))
      loc = "http://yosh.gimp.org/";
   else if (!strcmp(tail, "snorfle"))
      loc = "http://www.snorfle.net/";
   else if (!strcmp(tail, "dillo"))
      loc = "http://www.dillo.org/";
   else if (!strcmp(tail, "help"))
      loc = "http://www.dillo.org/dillo-help.html";
   else
      loc = "http://www.google.com/";

   LocUrl = a_Url_new(loc, NULL, 0, 0, 0);
   a_Nav_push(web->bw, LocUrl);
   a_Url_free(LocUrl);
   return -1;
}

/*
 * CCC function for the ABOUT module
 */
void a_About_ccc(int Op, int Branch, int Dir, ChainLink *Info,
                 void *Data1, void *Data2)
{
   int FD;

   a_Chain_debug_msg("a_About_ccc", Op, Branch, Dir);

   if ( Branch == 1 ) {
      /* Start about method */
      if (Dir == BCK) {
         switch (Op) {
         case OpStart:
            /* (Data1 = Url;  Data2 = Web) */
            // Info->LocalKey gets set in About_get
            if ((FD = About_get(Info, Data1, Data2)) == -1)
               a_Chain_fcb(OpAbort, Info, NULL, NULL);
            break;
         case OpAbort:
            a_Chain_bcb(OpAbort, Info, NULL, NULL);
            g_free(Info->LocalKey);
            g_free(Info);
            break;
         }
      } else {  /* FWD */
         switch (Op) {
         case OpSend:
            /* This means the sending framework was set OK */
            FD = ((SplashInfo_t *)Info->LocalKey)->FD_Read;
            a_Chain_fcb(OpSend, Info, &FD, NULL);
            break;
         case OpEnd:
            /* Everything sent! */
            a_Chain_del_link(Info, BCK);
            g_free(Info->LocalKey);
            a_Chain_fcb(OpEnd, Info, NULL, NULL);
            break;
         case OpAbort:
            g_free(Info->LocalKey);
            a_Chain_fcb(OpAbort, Info, NULL, NULL);
            break;
         }
      }
   }
}

