/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef POST_H
#define POST_H

#include <QFrame>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QTextBrowser>
#include <QLabel>
#include <QIcon>
#include <QPixmap>
#include <QPushButton>
#include <QString>
#include <QStringList>
#include <QMap>
#include <QFile>
#include <QResizeEvent>
#include <QVariantList>
#include <QMessageBox>

#include <QDebug>


#include "timestamp.h"
#include "mischelpers.h"
#include "pumpcontroller.h"
#include "commenterblock.h"
#include "imageviewer.h"


class Post : public QFrame
{
    Q_OBJECT

public:
    Post(PumpController *pumpController,
         QMap<QString,QString> postData,
         QVariantList lastLikesVariantList,
         QVariantList lastCommentsVariantList,
         QVariantList lastSharesVariantList,
         QWidget *parent = 0);
    ~Post();

    QString likesURL();
    void setLikes(QVariantList likesList);
    void setLikesLabel(int likesCount);

    QString commentsURL();
    void setComments(QVariantList commentsList);
    void setCommentsLabel(int commentsCount);

    QString sharesURL();
    void setShares(QVariantList sharesList);
    void setSharesLabel(int resharesCount);

    void setPostUnreadStatus();

signals:
    void postRead();


public slots:
    void likePost(bool like);
    void fixLikeButton(QString state);
    void getAllLikes();

    void commentOnPost();
    void sendComment(QString comment);
    void getAllComments();

    void sharePost();

    void deletePost();

    void openClickedURL(QUrl url);
    void showHighlightedURL(QUrl url);


protected:
    virtual void resizeEvent(QResizeEvent *event);
    virtual void mousePressEvent(QMouseEvent *event);
    virtual void leaveEvent(QEvent *event);


private:
    QHBoxLayout *mainLayout;
    QVBoxLayout *leftColumnLayout;
    QVBoxLayout *rightColumnLayout;

    QString postID;
    QString postType;
    bool postIsOwn;
    bool postIsUnread;

    QLabel *postAuthorAvatar;
    QLabel *postAuthorNameLabel;
    QLabel *postCreatedAtLabel;
    QLabel *postToLabel;
    QLabel *postCCLabel;
    QLabel *openInBrowserLabel;
    QLabel *postIsSharedLabel;

    QLabel *postLikesCountLabel;
    QLabel *postCommentsCountLabel;
    QLabel *postResharesCountLabel;


    QHBoxLayout *postTextLayout;
    QTextBrowser *postText;
    QLabel *highlightedUrlLabel;

    QHBoxLayout *buttonsLayout;
    QPushButton *likeButton;
    QPushButton *commentButton;
    QPushButton *shareButton;
    QPushButton *deleteButton;


    QString postImageTitle;

    QStringList imageList;
    QString postLikesURL;
    QString postCommentsURL;
    QString postSharesURL;


    PumpController *pController;
    CommenterBlock *commenter;
};

#endif // POST_H
