/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/diff.cpp
 *
 * @brief [LEVEL: alpha] Implementation of @ref
 * diagnostics::internal::diff_text
 *
 * $Id: diff.cpp 861 2009-04-18 20:14:51Z tautschnig $
 * 
 * @author Piotr Esden-Tempski
 */

#include <diagnostics/util/diff.hpp>

#include <diagnostics/util/diff_generator.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;

void diff_text(::std::string const & texta,
	       ::std::string const & textb, 
	       ::std::string & result, 
	       bool const use_color){
    Diff_Generator dg;
    dg.texta(texta);
    dg.textb(textb);
    dg.diff_text(result, use_color);
}


::std::string diff_text(::std::string const & texta,
			::std::string const & textb, 
			bool const use_color){
    ::std::string result;
    diff_text(texta, textb, result, use_color);
    return result; // one extra copy
}

INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
