/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/list_test_suite_traversal.t.cpp
 *
 * @brief [LEVEL: alpha] testing @ref diagnostics::unittest::List_Test_Suite_Traversal
 *
 * $Id: list_test_suite_traversal.t.cpp,v 1.13 2005/06/23 09:54:26 esdentem Exp $
 *
 * @author Christian Schallhart
 */
#include <diagnostics/unittest.hpp>

#include <diagnostics/unittest/test_system/list_test_suite_traversal.hpp>

// used components
#include <diagnostics/unittest/test_system/test_list_result.hpp>

// test support
#include <diagnostics/util/dump_test_suite.ts.hpp>
#include <diagnostics/util/dummy_test_suite_traversal.ts.hpp>
#include <diagnostics/util/test_suites.ts.hpp>


#include <sstream>

#define TEST_COMPONENT_NAME List_Test_Suite_Traversal
#define TEST_COMPONENT_NAMESPACE diagnostics::unittest

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;
TEST_COMPONENT_TEST_NAMESPACE_BEGIN;

void dump_simple_test_suite(Test_Data & test_data)
{
    
    Test_Suite *s1(simple_test_suite());

    TEST_ASSERT(test_data.compare("A",dump_test_suite(s1,"/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-S2-A",dump_test_suite(s1,"/*/S2/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-S3-A",dump_test_suite(s1,"/*/S3/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-A-C1",dump_test_suite(s1,"/*/*/C1",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-A-C2",dump_test_suite(s1,"/*/*/C2",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-A-A",dump_test_suite(s1,"/*/*/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-C1",dump_test_suite(s1,"/*/C1",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-A",dump_test_suite(s1,"/*/*",LEVEL_TEST)));

    delete s1;
}


void dump_simple_unnamed_test_suite(Test_Data & test_data)
{
    
    Test_Suite *s1(simple_unnamed_test_suite());

    TEST_ASSERT(test_data.compare("A",dump_test_suite(s1,"/*",LEVEL_TEST)));

    delete s1;
}


void dump_test_suite_all_test_case_variations(Test_Data & test_data)
{
    
    Test_Suite *s1(test_suite_all_test_case_variations());

    TEST_ASSERT(test_data.compare("A",dump_test_suite(s1,"/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-S2-A",dump_test_suite(s1,"/*/S2/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-S3-A",dump_test_suite(s1,"/*/S3/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-A-name2",dump_test_suite(s1,"/*/*/name2",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-A-name3",dump_test_suite(s1,"/*/*/name3",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-A-A",dump_test_suite(s1,"/*/*/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-name2",dump_test_suite(s1,"/*/name2",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("A-A",dump_test_suite(s1,"/*/*",LEVEL_TEST)));

    delete s1;
}

void dump_and_traverse_simple_test_suite_twice(Test_Data & test_data)
{
    
    Test_Suite *s1(simple_test_suite());

    typedef ::diagnostics::unittest::List_Test_Suite_Traversal::Test_List_Results_t Results_t;
    Results_t results;
    ::diagnostics::unittest::List_Test_Suite_Traversal trav(results);
    
    trav.traverse(*s1,"/*",LEVEL_TEST);
    trav.traverse(*s1,"/*",LEVEL_TEST);
    
    Results_t::const_iterator cur(results.begin());
    Results_t::const_iterator const end(results.end());
    ::std::ostringstream stream;
    for(;cur!=end;++cur) {
	stream << **cur << '\n';
	delete *cur;
    }
    

    TEST_ASSERT(test_data.compare("twice",stream.str()));

    delete s1;
}


TEST_COMPONENT_TEST_NAMESPACE_END;
TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

TEST_SUITE_BEGIN;
TEST_NORMAL_CASE(&dump_simple_test_suite,LEVEL_PROD);
TEST_NORMAL_CASE(&dump_simple_unnamed_test_suite,LEVEL_PROD);
TEST_NORMAL_CASE(&dump_test_suite_all_test_case_variations,LEVEL_PROD);
TEST_NORMAL_CASE(&dump_and_traverse_simple_test_suite_twice,LEVEL_PROD);
//TEST_ABNORMAL_CASE(Incorrect_Trace_Processing<Trace_With_Two_Test_Case_Enter_Msgs>(),LEVEL_PROD);
TEST_SUITE_END;

STREAM_TEST_SYSTEM_MAIN;
// vim:ts=4:sw=4
