/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */



#include <diagnostics/extensions/instrumentation/load_symbol.hpp>

#include <diagnostics/macros/block_annotation.hpp>
#include <diagnostics/util/to_string.hpp>

#include <dlfcn.h>

DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;

void * load_symbol(char const * const lib_name,
		   char const * const sym_name)
{
	DIAGNOSTICS_BASE_BLOCK_GUARD(LEVEL_SYSTEM,TYPE_BLOCK_ENTER,TYPE_BLOCK_EXIT,0, 
								 to_string("INST: Loading '",sym_name,"' from '",lib_name,"'"));

	void * const handle(dlopen(lib_name, RTLD_LAZY));
    char const *err;
    if((err=dlerror())) {
		::std::string const msg(to_string("INST: Opening '",lib_name,"' FAILED: '",err,"'"));
		DIAGNOSTICS_BASE_LOG(LEVEL_SYSTEM,TYPE_TRACE,0, msg);
		DIAGNOSTICS_PANIC_LOG(msg);
		exit (1);
    }
	
    void * const result(dlsym(handle,sym_name));
    if((err=dlerror())) {
		::std::string const msg(to_string("INST: Loading: '",sym_name,"' FAILED: '",err,"'"));
		DIAGNOSTICS_BASE_LOG(LEVEL_SYSTEM,TYPE_TRACE,0, msg);
		DIAGNOSTICS_PANIC_LOG(msg);
		exit (1);
    }
    return result;
}

INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
