/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "namedemultiplexer.h"
#include "gui.h"
#include "iwc.h"
#include "positionarrange.h"
#include "shellgui.h"
#include "filemanager.h"
#include "iconmanager.h"
#include "stringfunctions.h"
#include "global.h"
#include <stdlib.h>
#include <string.h>

/*subfolder="" */

int CopyCall(int x,int y,char *filenames,char *subfolder,int move)
{
  int i=1;
  int j;
  int k,l;
  int answer=YES;
  char *text;
  char *text2;
  char *text3;
  char *text4;
  char *rename;
  int statusb=0;
  int status=0;
  char *goal,*source;
  int number=0;
  k=0;
  j=0;
  while (filenames[j]!=0) {
    if (filenames[j]=='\\') 
      j++;
    else if (filenames[j]==' ') 
      k++;
    j++;
  }
  ShellWindowInit(k);
  do {
    j=i;
    do {
      if (filenames[j]=='\\') j++;
      j++;
    } while (filenames[j]!=' ' && filenames[j]!=0);
    text3=malloc(j-i+1);
    strncpy(text3,filenames+i,j-i);
    text3[j-i]=0;
    
    text=GenerateDeBackslashName(text3);
    k=0;l=0;
    while (text[k+1]!=0){
      if (text[k]=='/')
	l=k;
      k++;
    }
    text2=malloc(strlen(text+l)+strlen(GetPath())+strlen(subfolder)+1);
    strcpy(text2,GetPath());
    strcat(text2,subfolder);
    strcat(text2,text+l+1);
    if (FileExist(text2)==True) {
      if (answer!=ALL) {
	do {
	  if (strcmp(text2,text)==0) {
	    answer=CANCEL;
	    rename=malloc(1);
	  } else
	    answer=OverwriteQuestion(text2,&rename);
	  if (answer==RENAME) {
	    if (text2[strlen(text2)-1]=='/') {
	      free(text2);
	      text2=malloc(strlen(rename)+strlen(GetPath())+strlen(subfolder)+2);
	      strcpy(text2,GetPath());
	      strcat(text2,subfolder);
	      strcat(text2,rename);
	      strcat(text2,"/");
	    } else {
	      free(text2);
	      text2=malloc(strlen(rename)+strlen(GetPath())+strlen(subfolder)+1);
	      strcpy(text2,GetPath());
	      strcat(text2,subfolder);
	      strcat(text2,rename);
	    }
	  }
	  free(rename);
	} while(answer==RENAME && FileExist(text2)==True);
      }
      if (answer==YES || answer==ALL) {
	if (EraseFile(text2)!=NO_ERROR) {
	  status=REPORT_ERROR;
  	  answer=NO;
	} else {
	  /*delete info in DB*/
          text4=malloc(strlen(text2)+2);
          strcpy(text4,text2);
          if (text4[strlen(text4)-1]=='/')
            text4[strlen(text4)-1]=0;
          else
            strcat(text4,"/");
          EraseFileInfoInDesktop(text4);
          EraseFileInfoInDesktop(text2);
          free(text4);
          if (GetKindOfWindow()==NORMAL)
            UpdateIcons(True);
	}
      } else if (answer==NO) {
        status=DONT_DELETE_ORGINALS_ERROR;
      }
    } else {
      if (answer!=ALL)
	answer=YES;
    }
    if (move==True)
      ShellWindowInfo("DFM Move",text,text2,number);
    else
      ShellWindowInfo("DFM Copy",text,text2,number);    
    if (answer==YES || answer==ALL || answer==RENAME) {
      statusb=CopyFile(text,text2,subfolder,move);
      if      (status==NO_ERROR && 
                                   (statusb==ASK_FOR_DELETE_ERROR || 
			            statusb==DONT_DELETE_ORGINALS_ERROR || 
			            statusb==REPORT_ERROR || 
			            statusb==BREAK_ERROR))
	status=statusb;
      else if (status==ASK_FOR_DELETE_ERROR && 
                                   (statusb==DONT_DELETE_ORGINALS_ERROR || 
			            statusb==REPORT_ERROR || 
			            statusb==BREAK_ERROR))
	status=statusb;
      else if (status==DONT_DELETE_ORGINALS_ERROR &&  
                                   (statusb==REPORT_ERROR || 
			            statusb==BREAK_ERROR))
	status=statusb;
      else if (status==REPORT_ERROR && statusb==BREAK_ERROR)
	status=statusb;

      if (status==NO_ERROR && subfolder[0]==0) {
	goal=GenerateDeBackslashName(text2);
	source=GenerateDeBackslashName(text);
	CopyInfo(goal,source,x,y,i);
	free(source);
	free(goal);
      }
    }
    i=j+1;
    free(text);
    free(text2);
    free(text3);
    if (ShellWindowUpdate()==True || answer==CANCEL)
      status=BREAK_ERROR;
    number++;
  } while (filenames[j]!=0 && status!=BREAK_ERROR && status!=REPORT_ERROR);
  ShellWindowDestroy();
  return(status);
}

int EraseCall(char *filenames,int ask,int remote)
{
  int i=1;
  int j;
  char *text;
  char *textf;
  int status=NO_ERROR;
  int answer=YES;
  ShellWindowInit(1);

  do {
    j=i;
    do {
      if (filenames[j]=='\\') j++;
      j++;
    } while (filenames[j]!=' ' && filenames[j]!=0);
    text=malloc(j-i+1);
    strncpy(text,filenames+i,j-i);
    text[j-i]=0;
    if (FileExist(text)==True) {
      textf=GenerateDeBackslashName(text);
      ShellWindowInfo("DFM Erase",text,"",1);    
      if (ask==True && answer!=ALL) {
	if (remote==True)
	  answer=EraseQuestionOnDifferent(textf);
	else
	  answer=EraseQuestion(textf);
      }
      free(textf);
      if (ask==False || answer==ALL || answer==YES)
	status=EraseFile(text);
      if (GetKindOfWindow()==NORMAL)
	UpdateIcons(True);
    }
    free(text);
    i=j+1;
    if (ShellWindowUpdate()==True || answer==CANCEL)
      status=BREAK_ERROR;
  } while (filenames[j]!=0 && status!=BREAK_ERROR && status!=REPORT_ERROR);
  ShellWindowDestroy();
  return(status);
}

int LinkCall(int x,int y,char *filenames,char *subfolder)
{
  int i=1;
  int j;
  char *text;
  char *text2;
  int status=NO_ERROR;
  ShellWindowInit(1);
  do {
    j=i;
    do {
      if (filenames[j]=='\\') j++;
      j++;
    } while (filenames[j]!=' ' && filenames[j]!=0);
    text2=malloc(j-i+1);
    strncpy(text2,filenames+i,j-i);
    text2[j-i]=0;
    text=GenerateDeBackslashName(text2);
    ShellWindowInfo("DFM Link",text,"",1);    
    status=LinkFile(text,subfolder);
    SetNextPosition(x,y);
    free(text);
    free(text2);
    i=j+1;
    if (ShellWindowUpdate()==True)
      status=BREAK_ERROR;
  } while (filenames[j]!=0 && status!=BREAK_ERROR && status!=REPORT_ERROR);
  ShellWindowDestroy();
  return(status);
}
