#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute this file and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this file.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.


	
		
		


	


class plugin_Search:

	class SEngines:
		def __init__(self, filepath=None, parent=None):
			self.engines = dict({})
			self.parent = parent
			if (filepath):
				self.load_from_file(filepath)
			
	
		def load_from_file(self, filepath):
			dc.debugmsg("Loading from file"+ filepath)
			# First, check to see if the file exists
			if not os.path.basename(filepath) in os.listdir(dc.CONFIG_DIR):
				self.save_to_file(filepath)
				dc.debugmsg("config file not found, creating")
			
			else:
				try:
					from xml.sax import saxutils
					from xml.sax import make_parser
					from xml.sax.handler import feature_namespaces
					from xml.sax import ContentHandler
					# Create a parser
					parser = make_parser()
				
					# Tell the parser we are not interested in XML namespaces
					parser.setFeature(feature_namespaces, 0)
				
					# Create the handler
					dh = self.parent.SXMLParser()
				
					# Tell the parser to use our handler
					parser.setContentHandler(dh)
				
					# Parse the input
					parser.parse(filepath)
						
					self.engines = dh.engines
				except:
					dc.debugmsg("An error occured while loading config, creating new file")
					self.save_to_file(filepath)
			print "SE loaded from", filepath
				
		def save_to_file(self, filepath):
			dc.debugmsg("writing engines to file")
			f = open(filepath, 'w')
			f.write('<search_engines>\n')
			
			for k in self.engines.keys():
				dc.debugmsg("Writing engine "+ k+ " with string of "+ self.engines[k])
				f.write('\t<engine name="')
				f.write(k)
				f.write('">')
				f.write(str(self.engines[k]))
				f.write('</engine>\n')
						
			f.write('</search_engines>\n')
			
		def show_dlg(self):
			return self.parent.SearchDialog(self).run()
			
		def keys(self):
			return self.engines.keys()
	
		def get(self, name):
			return self.engines[name]
			
		def clear(self):
			self.engines = {}
			
	class SearchDialog:
		def __init__(self, se=None):
			self.se = se
			self.gladefile = dc.APP_PATH + "/plugins/searchdlg.glade"
			self.wTree = gtk.glade.XML(self.gladefile, "SearchDialog")
			self.dlg = self.wTree.get_widget("SearchDialog")
			self.dlg.set_icon_from_file(dc.get_icon("deluge-32.png"))
			
			dic = {	"add_clicked"	: self.add_clicked,
				"del_clicked"	: self.del_clicked,
				"row_clicked"	: self.row_clicked,
				"text_changed"	: self.text_changed }
				
			self.wTree.signal_autoconnect(dic)
			
			self.search_view = self.wTree.get_widget("search_view")
			self.search_list = gtk.ListStore(str, str)
			self.search_view.set_model(self.search_list)
			self.search_view.get_selection().set_select_function(self.row_clicked)
			
			c = 0
			for name in [_("Name"), _("Search string")]:
				column = gtk.TreeViewColumn(name, gtk.CellRendererText(), text=c)
				column.set_resizable(True)
				column.set_sort_column_id(c)
				self.search_view.append_column(column)			
				c=c+1
			
			self.field_name = self.wTree.get_widget("field_name")		
			self.field_search = self.wTree.get_widget("field_search")
			self.button_add = self.wTree.get_widget("button_addsearch")
			self.button_del = self.wTree.get_widget("button_delsearch")
	
			self.button_add.set_sensitive(0)
			self.button_del.set_sensitive(0)		
			
			if(self.se):
				for name in self.se.engines.keys():
					self.search_list.append([name,
						self.se.engines[name]])
	
			
		def run(self):	  
			self.dlg.show_all()
			response = self.dlg.run()
			dc.debugmsg(response)
			
			if (response):
				self.se.clear()
				siter = self.search_list.get_iter_first()
				while siter is not None:
					self.se.engines[self.search_list.get_value(siter, 0)]=self.search_list.get_value(siter, 1)
					siter = self.search_list.iter_next(siter)
			
			self.dlg.destroy()
			return response
			
		def add_clicked(self, args):
			self.search_list.append([self.field_name.get_text(),
						self.field_search.get_text()])
			self.field_name.set_text("")
			self.field_search.set_text("")
			dc.debugmsg("add_clicked")
				
		def del_clicked(self, args):
			(temp, selection) = self.search_view.get_selection().get_selected()
			self.search_list.remove(selection)
			self.button_del.set_sensitive(0)
			dc.debugmsg("del_clicked")
				
		def row_clicked(self, args):
			dc.debugmsg("row_clicked")
			self.button_del.set_sensitive(1)
			return True
				
		def text_changed(self, args):
			a = (self.field_name.get_text() != "")
			b = (self.field_search.get_text() != "")
			if(a and b):
				self.button_add.set_sensitive(1)
			else:
				self.button_add.set_sensitive(0)
	##
	## Copied from dpref.py, still needs to be modified
	##
	from xml.sax import ContentHandler
	
	class SXMLParser(ContentHandler):
		def __init__(self):
			self.inOptionContent = 0
			self.engines = {}
			dc.debugmsg("SXMLParser")
	
		def startElement(self, name, attrs):
			dc.debugmsg(name)
			if name == 'engine':
				dc.debugmsg("found engine tag")
				self.inOptionContent = 1
				self.optType = self.normalize_whitespace(attrs.get('name', None))
				dc.debugmsg(self.optType)
				self.optVal = ""
	
		def characters(self, ch):
			if self.inOptionContent:
				self.optVal = self.optVal + ch
	
		def endElement(self, name):
			if name == 'engine':
				self.inOptionContent = 0
				self.optVal = self.normalize_whitespace(self.optVal)
				dc.debugmsg(self.optVal)
				dc.debugmsg("Read"+ self.optType + ":"+ self.optVal)
				self.engines[self.optType] = self.optVal
		
		def normalize_whitespace(self,text):
			return ' '.join(text.split())

	# __init is called when the plugin is actually activated, i.e. checked in
	# the plugin manager dialog, which may occur on startup if the plugin was
	# previously activated. Registration of a plugin does NOT call __init__;
	# see belowhDialog
	def __init__(self, parent, location):
		# Using this, you can access the Deluge client
		self.parent = parent
		self.toolbar = self.parent.tb_right
		# The directory where the plugin resides.
		self.location = location 
		self.se = None
		try:
			import gtk, pygtk, gtk.glade
			import sys, os, shutil
			from xml.sax import saxutils
			from xml.sax import make_parser
			from xml.sax.handler import feature_namespaces
			from xml.sax import ContentHandler
		except:
			dc.ShowPopupWarning(self.parent.window, "Search Plugin: not all necessary dependencies are installed.")
			return
		self.search_engines = self.SEngines(dc.CONFIG_DIR + "/searchengines.xml", self)
		# The widgets that will make up the plugin
		self.search_entry = gtk.Entry()
		self.search_item = gtk.ToolItem()
		self.search_item.add(self.search_entry)
		self.search_icon = gtk.Image()
		self.search_icon.set_from_stock(gtk.STOCK_FIND, gtk.ICON_SIZE_MENU)
		self.menu_button = gtk.MenuToolButton(self.search_icon, "Choose an Engine")
		self.menu_button.set_is_important(True)
		self.menu_button.connect("clicked", self.torrent_search)
		self.menu = gtk.Menu()
		self.manage_item = gtk.ImageMenuItem("Manage Engines")
		self.image = gtk.Image()
		self.image.set_from_stock(gtk.STOCK_PREFERENCES, gtk.ICON_SIZE_MENU)
		self.manage_item.set_image(self.image)
		self.manage_item.connect("activate", self.configure)
		
		self.menu.add(self.manage_item)
		self.menu_button.set_menu(self.menu)
		
		self.toolbar.insert(self.search_item, -1)
		self.toolbar.insert(self.menu_button, -1)
		
		self.populate_search_menu()
		
		self.search_item.show_all()
		self.menu_button.show_all()
		self.menu.show_all()
		print "Search Plugin Loaded Sucessfully"
		

	# Shutdown is called when the plugin is deactivated, i.e. unchecked from the
	# plugin manager dialog, or when Deluge is closed
	def shutdown(self):
		self.toolbar.remove(self.search_item)
		self.toolbar.remove(self.menu_button)

	# Update is called one per 'tick' (usually once per second,
	# this tick timescale value is stored in dc.UPDATE_INTERVAL in
	# milliseconds)
	def update(self):
		pass

	# Called when the user asks to configure the plugin. This should show a
	# configuration dialog window, etc. You only need to define this for
	# configurable plugins, of course (see below)
	def configure(self, menuitem=None):
		self.search_engines.show_dlg()
		self.populate_search_menu()
		
	def populate_search_menu(self, args=None):
		self.menu_button.set_label("Choose an Engine")
		for child in self.menu.get_children():
			if (child is not self.manage_item):
				self.menu.remove(child)
		group = None
		i = 0
		for name in self.search_engines.keys():
			dc.debugmsg(name)
			rmi = gtk.RadioMenuItem(None, name)
			rmi.eng_name = name
			rmi.connect("activate", self.select_search, rmi.eng_name)
			if (group != None):
				rmi.set_group(group)
			else:
				group = rmi
				rmi.set_active(1)
			self.menu.insert(rmi, i)
			i = i + 1
			rmi.show()
			
		
		self.menu_button.set_menu(self.menu)
		self.menu.show_all()

	def select_search(self, menuitem, engine_string):
		self.menu_button.set_label("Search " + engine_string)
		self.se = engine_string
		
	def torrent_search(self, args=None):
		engine = None
		for child in self.menu.get_children():
			if (child is not self.manage_item):
				if child.get_active():
					engine = child.eng_name
		url = str(self.search_engines.get(engine))
		dc.debugmsg(url.find("%%query%%"))
		query = self.search_entry.get_text()
		dc.debugmsg(query)
		query = query.replace(" ", "+")
		dc.debugmsg(query)
		if (url.find("%%query%%") > -1):
			url = url.replace("%%query%%", query)
			dc.debugmsg("replacing")
		else:
			url = url + self.search_entry.get_text()
		dc.debugmsg(url)
		dc.open_url_in_browser(url)



# Register plugin with Deluge. Registration only adds the plugin to the list
# of plugins that appear in the plugin manager window. It does NOT activate
# the plugin. However, if a plugin is set to be activated (i.e. the user's
# preference was to activate it, last time Deluge was run), then the
# plugin will indeed be activated by the plugin manager (some time after
# registration).

PLUGINregister("Torrent Search Bar", # Name to appear on plugin in plugin manager
               plugin_Search,		# The plugin class defined before
               True, # whether this plugin has a 'configuration' option, i.e.
                      # whether the 'configure' button can be pressed in the
                      # plugin manager
               False, # whether this plugin should be activated by default, for
                      # users with no preference for this plugin as of yet. This
                      # is only of effect the FIRST time a user loads a plugin,
                      # afterwards the user's preferences are the default. Thus,
                      # this is of use in the scenario where you roll out a new
                      # plugin, and want users to have it activated automatically
			   "A bittorrent search plugin\n\nWritten by zachtib")