#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute this file and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this file.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.

class plugin_ARIAAAI:
	def __init__(self, parent, location):
		self.parent = parent # Using this, you can access the Deluge client
		self.location = location

		self.maxCounter = (10*1000)/dc.UPDATE_INTERVAL
		self.counter = self.maxCounter

		self.warningTauInit = 2
		self.maxWarningTau  = 6

		self.minPeersToCheck 			 = 25
		self.minNonTrivialPeersToCheck = 15
		self.maxPrevalence 				 = 0.2

		self.warnings = {}
	def shutdown(self):
		pass
	def update(self):
		if self.counter == 0:
			self.counter = self.maxCounter
			for torrent in self.parent.handler.torrent_list:
				if not self.evaluateTorrent(torrent):
					break
		else:
			self.counter = self.counter - 1

		self.parent.statusBarTempMessage = self.parent.statusBarTempMessage + dc.STATUSBAR_DIVIDER + "[ARIAAAI]"

	def evaluateTorrent(self, torrent):
		peers = torrent.getPeerInfo()
		if peers is None:
			return True
		if len(peers) < self.minPeersToCheck:
			return True
#		print "Peers: ", len(peers)
		nonTrivialPeers = 0
#		print "ARIAAAI. NumPeers: ", len(peers), "cutoff: ", cutoff
		# Calculate prevalences of the percentages
		counts = {}

		for peer in peers:
			percentage = peer['peerHas']
			if percentage == 0. or percentage == 100.:
				continue
			nonTrivialPeers = nonTrivialPeers + 1
			try:
				old = counts[percentage]
				counts[percentage] = old + 1
			except KeyError:
				counts[percentage] = 1
#		print "NonTrivialPeers: ", nonTrivialPeers

		if nonTrivialPeers < self.minNonTrivialPeersToCheck:
			return True

		cutoff = int(self.maxPrevalence * nonTrivialPeers)
#		print "Cutoff: ", cutoff

		for percentage,count in counts.iteritems():
			if count >= cutoff:
				self.warn(torrent.getName(), percentage, count)
				return False
		
		return True

	def warn(self, name, percentage, count):
		showWarning = False
		if name not in self.warnings.keys():
			self.warnings[name] = [self.warningTauInit, 2]
			showWarning = True
		else:
			if self.warnings[name][0] == 0:
				self.warnings[name][0] = self.warnings[name][1] * self.warningTauInit
				self.warnings[name][1] = min(self.warnings[name][1] * 2, self.maxWarningTau)
				showWarning = True
			else:
				self.warnings[name][0] = self.warnings[name][0] - 1

		if showWarning:
			self.parent.addMessage(_("There is suspicious activity in") + " '" + name + \
				"'. " + _("The torrent may be poisoned by the RIAA/MPAA. Found") + " " + str(percentage) + \
				"% " + _("at prevalence") + " " + str(count), "C")


### Register plugin with Deluge
PLUGINregister("Anti-RIAA AI", plugin_ARIAAAI, False, False,
					"Anti-RIAA AI plugin v0.1\n\nWritten by Kripkenstein")
