#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute this file and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this file.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.

import sys, os, shutil
try:
 	import pygtk
  	pygtk.require("2.0")
except:
  	pass
try:
	import gtk
  	import gtk.glade
except:
	sys.exit(1)
import delugecommon
dc = delugecommon

def get_new_tray_icon(parent):
	try:
		dc.debugmsg("Trying to use new tray icon")
		systray = DTray(parent)
		dc.debugmsg("Success!")
		return systray
	except:
		pass
	try:
		dc.debugmsg("Error: reverting to old tray icon")
		import egg.trayicon
		systray = DTray_legacy(parent)
		return systray
	except:
		pass
	systray = DummyTray(parent)
	return systray
#
# This system tray will be used on versions of PyGTK >= 2.10
#
class DTray:
	def __init__(self, parent):
		dc.debugmsg("System Tray Created")
		self.parent = parent
		self.gladefile = dc.get_glade("traymenu.glade")
		self.wTree = gtk.glade.XML(self.gladefile)
		self.menu = self.wTree.get_widget("TrayMenu")
		dic = {	"menu_add"		: self.parent.interactive_open_torrent,
			"menu_update_trackers"	: self.parent.update_all,
			"menu_clear_finished"	: self.parent.ClearFinished,
			"menu_preferences"	: self.parent.ShowPrefDialog,
			"menu_quit"		: self.parent.MenuQuit
		      }
		self.wTree.signal_autoconnect(dic)
		
		self.start()

	def start(self):
		dc.debugmsg("Using new system tray")
		self.tray = gtk.StatusIcon()
		self.tray.set_from_file(dc.get_icon("deluge-32.png"))
		self.tray.set_tooltip("Deluge Bittorrent Client")
		self.tray.connect("popup-menu", self.show_menu, None)
		self.tray.connect("activate", self.show_hide, None)
		
	def show_hide(self, status_icon, arg=None):
		self.parent.ShowHideWindow()
		
	def show_menu(self, status_icon, button, activate_time, arg0=None):
		self.menu.popup(None, None, None, button, activate_time)
		
	def destroy(self):
		self.tray.set_visible(False)
	
	def update_tooltip(self, connections, dlrate, ulrate):
		msg = _("Deluge Bittorrent Client") + "\n" + \
			_("Connections") + ": " + connections + "\n" + _("Download") + ": " + dlrate + "\n" + \
			_("Upload") + ": " + ulrate
		self.set_tooltip(msg)
	
	def set_tooltip(self, msg):
		self.tray.set_tooltip(msg)
		
	def exists(self):
		return True
		
##
## This class is included to support versions of PyGTK < 2.9
##
class DTray_legacy(DTray):
		
	def start(self):
		dc.debugmsg("Using old system tray")
		import egg.trayicon
		##System Tray
		self.tooltips = gtk.Tooltips()
		self.trayicon = gtk.Image()
		self.trayicon.set_from_file(dc.get_icon("deluge-22.png"))
		self.traybox = gtk.EventBox()
		self.traybox.add(self.trayicon)
		self.traybox.connect("button_press_event", self.tray_clicked)
		self.tooltips.set_tip(self.traybox, "Deluge Bittorrent Client")
		self.tray = egg.trayicon.TrayIcon("TrayIcon")
		self.tray.add(self.traybox)
		self.tray.show_all()
		
	def tray_clicked(self, widget, event):
		if event.button == 1:
			self.show_hide(None)
		elif event.button == 3:
			self.show_menu(None, event.button, event.time)
			
	def set_tooltip(self, msg):
		self.tooltips.set_tip(self.traybox, msg)
			
	def destroy(self):
		self.tray.hide()
#
# If the user cannot support either Tray, this is created
# to emulate the existance of a tray, but does nothing
#
class DummyTray(DTray):
	def __init__(self, parent):
		dc.debugmsg("Now using DummyTray.  No tray icon will be available")
		self.parent = parent
		
	def update_tooltips(self, arg):
		pass
	
	def destroy(self):
		dc.debugmsg("Msg from DummyTray: nothing to do")
		
	def exists(self):
		return False

	def set_tooltip(self, msg):
		pass
