#!/usr/bin/python
#
# deluge.py
# Copyright (C) Zach Tibbitts 2006 <zach@collegegeek.org>
# Copyright (C) Alon Zakai    2006 <kripkensteiner@gmail.com>
# 
# Deluge is free software.
# 
# You may redistribute this file and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option)
# any later version.
# 
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this file.  If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA  02110-1301, USA.

import sys, os, shutil
try:
 	import pygtk
  	pygtk.require("2.0")
except:
  	pass
try:
	import gtk
  	import gtk.glade
except:
	sys.exit(1)
from delugecommon import *


class AboutDialog:
	def __init__(self):
		gtk.about_dialog_set_url_hook(self.url, None)
		self.gladefile = get_glade("aboutdialog.glade")
		self.wTree = gtk.glade.XML(self.gladefile)
		self.dlg = self.wTree.get_widget("AboutDialog")
		self.dlg.set_icon_from_file(get_icon("deluge-32.png"))
		self.dlg.set_name(APP_NAME)	
		self.dlg.set_version(APP_VERSION)
		self.dlg.set_logo(gtk.gdk.pixbuf_new_from_file(get_icon("deluge-192.png")))
		
	def run(self):	  
		
		self.dlg.show_all()
		self.dlg.run()
		self.dlg.destroy()
		
	def url(self, dialog, link, user_data):
		open_url_in_browser(link)
		
