//////////////////////////////////////////////////////////////////////////////
// deKoratorconfig.cc
// -------------------
// DeKorator window decoration for KDE
// -------------------
// Autor: moty rahamim
// Email: moty.rahamim@gmail.com
// Based on Example-0.8 by David Johnson <david@usermode.org>
// some ideas and code have been taken from plastik and KCMicons
//////////////////////////////////////////////////////////////////////////////

#include <kconfig.h>
#include <klocale.h>
#include <kglobal.h>
#include <qbuttongroup.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qwhatsthis.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <kcolorbutton.h>
#include <klistview.h>

#include "deKoratorconfig.h"
#include "configdialog.h"
#include <themes.h>

#include <kurlrequester.h>

//////////////////////////////////////////////////////////////////////////////
// DeKoratorConfig()
// -------------
// Constructor

DeKoratorConfig::DeKoratorConfig( KConfig* config, QWidget* parent )
        : QObject( parent ), config_( 0 ), dialog_( 0 )
{
    // create the configuration object
    config_ = new KConfig( "kwindeKoratorrc" );
    KGlobal::locale() ->insertCatalogue( "kwin_deKorator_config" );



    // create and show the configuration dialog
    dialog_ = new ConfigDialog( parent );

    themes_ = new IconThemesConfig( dialog_, dialog_->themesKlstView , dialog_->removeThemBtn );

    dialog_->show();

    // load the configuration
    load( config_ );

    // setup the connections

    // misc
    connect( dialog_->titlealign, SIGNAL( clicked( int ) ),
             this, SLOT( selectionChanged( int ) ) );
    connect( dialog_->useMenuImageChkBox, SIGNAL( clicked() ), SIGNAL( changed() ) );
    connect( dialog_->dblClkCloseChkBox, SIGNAL( clicked() ), SIGNAL( changed() ) );
    connect( dialog_->showBtmBorderChkBox, SIGNAL( clicked() ), SIGNAL( changed() ) );
    connect( dialog_->useShdtextChkBox, SIGNAL( clicked() ), SIGNAL( changed() ) );
    connect( dialog_->activeShdtextXSpinBox, SIGNAL( valueChanged( int ) ), SIGNAL( changed() ) );
    connect( dialog_->activeShdtextYSpinBox, SIGNAL( valueChanged( int ) ), SIGNAL( changed() ) );
    connect( dialog_->activeShdColBtn, SIGNAL( clicked() ), SIGNAL( changed() ) );
    connect( dialog_->inActiveShdtextXSpinBox, SIGNAL( valueChanged( int ) ), SIGNAL( changed() ) );
    connect( dialog_->inActiveShdtextYSpinBox, SIGNAL( valueChanged( int ) ), SIGNAL( changed() ) );
    connect( dialog_->inActiveShdColBtn, SIGNAL( clicked() ), SIGNAL( changed() ) );
    connect( dialog_->inActiveShdColBtn, SIGNAL( clicked( ) ), SIGNAL( changed() ) );
    connect( dialog_->btnShiftXSpinBox, SIGNAL( valueChanged( int ) ), SIGNAL( changed() ) );
    connect( dialog_->btnShiftYSpinBox, SIGNAL( valueChanged( int ) ), SIGNAL( changed() ) );


    // colors
    connect( dialog_->colorizeFramesChkBox, SIGNAL( clicked() ), SIGNAL( changed() ) );
    connect( dialog_->colorizeButtonsChkBox, SIGNAL( clicked() ), SIGNAL( changed() ) );
    connect( dialog_->useAnimChkBox, SIGNAL( clicked() ), SIGNAL( changed() ) );
    connect( dialog_->animateEfeectsCombo, SIGNAL( activated( const QString& ) ), SIGNAL( changed() ) );
    connect( dialog_->hoverTypeCombo, SIGNAL( activated( const QString& ) ), SIGNAL( changed() ) );
    connect( dialog_->effectsAmount_SpinBox, SIGNAL( valueChanged( int ) ), SIGNAL( changed() ) );
    connect( dialog_->activeHighlightClrBtn, SIGNAL( clicked( ) ), SIGNAL( changed() ) );
    connect( dialog_->inActiveHighlightClrBtn, SIGNAL( clicked( ) ), SIGNAL( changed() ) );
    connect( dialog_->decoColorizeComboBox, SIGNAL( activated( const QString& ) ), SIGNAL( changed() ) );
    connect( dialog_->buttonsColorizeComboBox, SIGNAL( activated( const QString& ) ), SIGNAL( changed() ) );
    connect( dialog_->buttonsHoverColorizeComboBox, SIGNAL( activated( const QString& ) ), SIGNAL( changed() ) );


    // path's
    connect( dialog_->framesPathKurl, SIGNAL( textChanged( const QString& ) ), SIGNAL( changed() ) );
    dialog_->framesPathKurl->setMode( 2 );
    connect( dialog_->buttonsPathKurl, SIGNAL( textChanged( const QString& ) ), SIGNAL( changed() ) );
    dialog_->buttonsPathKurl->setMode( 2 );
    connect( dialog_->useMasks_Chkbox, SIGNAL( clicked() ), SIGNAL( changed() ) );
    connect( dialog_->masksPathKurl, SIGNAL( textChanged( const QString& ) ), SIGNAL( changed() ) );
    dialog_->masksPathKurl->setMode( 2 );

    // themes
    connect( dialog_->themesKlstView, SIGNAL( selectionChanged( QListViewItem * ) ),
             SLOT( themeSelected( QListViewItem * ) ) );
    connect( dialog_->installthemeBtn, SIGNAL( clicked( ) ), SLOT( installNewTheme() ) );
    connect( dialog_->removeThemBtn, SIGNAL( clicked( ) ), SLOT( removeSelectedTheme() ) );
    connect( dialog_->applyThemeBtn, SIGNAL( clicked( ) ), SLOT( setTheme() ) );

}

//////////////////////////////////////////////////////////////////////////////
// ~DeKoratorConfig()
// --------------
// Destructor

DeKoratorConfig::~DeKoratorConfig()
{
    if ( dialog_ ) delete dialog_;
    if ( config_ ) delete config_;
    if ( themes_ ) delete themes_;
}

//////////////////////////////////////////////////////////////////////////////
// selectionChanged()
// ------------------
// Selection has changed

void DeKoratorConfig::selectionChanged( int )
{
    emit changed();
}

//////////////////////////////////////////////////////////////////////////////
// load()
// ------
// Load configuration data

void DeKoratorConfig::load( KConfig* )
{
    // misc
    config_->setGroup( "MISC" );

    QString value = config_->readEntry( "TitleAlignment", "AlignHCenter" );
    QRadioButton *button = ( QRadioButton* ) dialog_->titlealign->child( value );
    if ( button ) button->setChecked( TRUE );
    dialog_->useMenuImageChkBox->setChecked( config_->readBoolEntry( "UseMenuImage", FALSE ) );
    dialog_->dblClkCloseChkBox->setChecked( config_->readBoolEntry( "DblClkClose", FALSE ) );
    dialog_->showBtmBorderChkBox->setChecked( config_->readBoolEntry( "ShowBtmBorder", FALSE ) );
    QColor color = QColor( 150, 150, 150 );
    dialog_->useShdtextChkBox->setChecked( config_->readBoolEntry( "UseShdtext", FALSE ) );
    dialog_->activeShdtextXSpinBox->setValue( config_->readNumEntry( "ActiveShdtextX", 0 ) );
    dialog_->activeShdtextYSpinBox->setValue( config_->readNumEntry( "ActiveShdtextY", 0 ) );
    dialog_->activeShdColBtn->setColor( config_->readColorEntry( "ActiveShadowColor", &color ) );
    dialog_->inActiveShdtextXSpinBox->setValue( config_->readNumEntry( "InActiveShdtextX", 0 ) );
    dialog_->inActiveShdtextYSpinBox->setValue( config_->readNumEntry( "InActiveShdtextY", 0 ) );
    dialog_->inActiveShdColBtn->setColor( config_->readColorEntry( "InActiveShadowColor", &color ) );
    dialog_->btnShiftXSpinBox->setValue( config_->readNumEntry( "BtnShiftX", 0 ) );
    dialog_->btnShiftYSpinBox->setValue( config_->readNumEntry( "BtnShiftY", 0 ) );


    // colors
    config_->setGroup( "COLORS" );

    dialog_->colorizeFramesChkBox->setChecked( config_->readBoolEntry( "ColorizeFrames", FALSE ) );
    dialog_->colorizeButtonsChkBox->setChecked( config_->readBoolEntry( "ColorizeButtons", FALSE ) );
    dialog_->useAnimChkBox->setChecked( config_->readBoolEntry( "UseAnimation", FALSE ) );
    dialog_->animateEfeectsCombo->setCurrentText( config_->readEntry( "AnimationType", "Intensity" ) );
    dialog_->activeHighlightClrBtn->setColor( config_->readColorEntry( "ActiveHighlightColor", &color ) );
    dialog_->inActiveHighlightClrBtn->setColor( config_->readColorEntry( "InActiveHighlightColor", &color ) );
    dialog_->hoverTypeCombo->setCurrentText( config_->readEntry( "ButtonsHoverType", "To Gray" ) );
    dialog_->effectsAmount_SpinBox->setValue( config_->readNumEntry( "EffectAmount", 5 ) );
    dialog_->decoColorizeComboBox->setCurrentText( config_->readEntry( "DecoColorize", "Liquid Method" ) );
    dialog_->buttonsColorizeComboBox->setCurrentText( config_->readEntry( "ButtonsColorize", "Liquid Method" ) );
    dialog_->buttonsHoverColorizeComboBox->setCurrentText( config_->readEntry( "ButtonsHoverColorize", "Liquid Method" ) );


    // path's
    config_->setGroup( "PATHS" );

    dialog_->framesPathKurl->setURL( config_->readEntry( "FramesPath", "" ) );
    dialog_->buttonsPathKurl->setURL( config_->readEntry( "ButtonsPath", "" ) );
    dialog_->useMasks_Chkbox->setChecked( config_->readBoolEntry( "UseMasks", FALSE ) );
    dialog_->masksPathKurl->setURL( config_->readEntry( "MasksPath", "" ) );
}

//////////////////////////////////////////////////////////////////////////////
// save()
// ------
// Save configuration data

void DeKoratorConfig::save( KConfig* )
{
    // misc
    config_->setGroup( "MISC" );

    QRadioButton *button = ( QRadioButton* ) dialog_->titlealign->selected();
    if ( button ) config_->writeEntry( "TitleAlignment", QString( button->name() ) );
    config_->writeEntry( "UseMenuImage", dialog_->useMenuImageChkBox->isChecked() );
    config_->writeEntry( "DblClkClose", dialog_->dblClkCloseChkBox->isChecked() );
    config_->writeEntry( "ShowBtmBorder", dialog_->showBtmBorderChkBox->isChecked() );
    config_->writeEntry( "UseShdtext", dialog_->useShdtextChkBox->isChecked() );
    config_->writeEntry( "ActiveShdtextX", dialog_->activeShdtextXSpinBox->value() );
    config_->writeEntry( "ActiveShdtextY", dialog_->activeShdtextYSpinBox->value() );
    config_->writeEntry( "ActiveShadowColor", dialog_->activeShdColBtn->color() );
    config_->writeEntry( "InActiveShdtextX", dialog_->inActiveShdtextXSpinBox->value() ); config_->writeEntry( "InActiveShdtextY", dialog_->inActiveShdtextYSpinBox->value() );
    config_->writeEntry( "InActiveShadowColor", dialog_->inActiveShdColBtn->color() );
    config_->writeEntry( "BtnShiftX", dialog_->btnShiftXSpinBox->value() );
    config_->writeEntry( "BtnShiftY", dialog_->btnShiftYSpinBox->value() );


    // colors
    config_->setGroup( "COLORS" );

    config_->writeEntry( "ColorizeFrames", dialog_->colorizeFramesChkBox->isChecked() );
    config_->writeEntry( "ColorizeButtons", dialog_->colorizeButtonsChkBox->isChecked() );
    config_->writeEntry( "UseAnimation", dialog_->useAnimChkBox->isChecked() );
    config_->writeEntry( "AnimationType", dialog_->animateEfeectsCombo->currentText() );
    config_->writeEntry( "ButtonsHoverType", dialog_->hoverTypeCombo->currentText() );
    config_->writeEntry( "EffectAmount", dialog_->effectsAmount_SpinBox->value() );
    config_->writeEntry( "ActiveHighlightColor", dialog_->activeHighlightClrBtn->color() );
    config_->writeEntry( "InActiveHighlightColor", dialog_->inActiveHighlightClrBtn->color() );
    config_->writeEntry( "DecoColorize", dialog_->decoColorizeComboBox->currentText() );
    config_->writeEntry( "ButtonsColorize", dialog_->buttonsColorizeComboBox->currentText() );
    config_->writeEntry( "ButtonsHoverColorize", dialog_->buttonsHoverColorizeComboBox->currentText() );


    // path's
    config_->setGroup( "PATHS" );

    config_->writeEntry( "FramesPath", dialog_->framesPathKurl->url() );
    config_->writeEntry( "ButtonsPath", dialog_->buttonsPathKurl->url() );
    config_->writeEntry( "UseMasks", dialog_->useMasks_Chkbox->isChecked() );
    config_->writeEntry( "MasksPath", dialog_->masksPathKurl->url() );

    config_->sync();
}

//////////////////////////////////////////////////////////////////////////////
// defaults()
// ----------
// Set configuration defaults

void DeKoratorConfig::defaults()
{

    // misc
    QRadioButton * button =
        ( QRadioButton* ) dialog_->titlealign->child( "AlignHCenter" );
    if ( button ) button->setChecked( TRUE );
    dialog_->useMenuImageChkBox->setChecked( FALSE );
    dialog_->dblClkCloseChkBox->setChecked( FALSE );
    dialog_->showBtmBorderChkBox->setChecked( FALSE );
    dialog_->useShdtextChkBox->setChecked( FALSE );
    dialog_->activeShdtextXSpinBox->setValue( 0 );
    dialog_->activeShdtextYSpinBox->setValue( 0 );
    dialog_->activeShdColBtn->setColor( QColor( 150, 150, 150 ) );
    dialog_->inActiveShdtextXSpinBox->setValue( 0 );
    dialog_->inActiveShdtextYSpinBox->setValue( 0 );
    dialog_->inActiveShdColBtn->setColor( QColor( 150, 150, 150 ) );
    dialog_->btnShiftXSpinBox->setValue( 0 );
    dialog_->btnShiftYSpinBox->setValue( 0 );


    // colors
    dialog_->colorizeFramesChkBox->setChecked( FALSE );
    dialog_->colorizeButtonsChkBox->setChecked( FALSE );
    dialog_->useAnimChkBox->setChecked( FALSE );
    dialog_->animateEfeectsCombo->setCurrentText( "Intensity" );
    dialog_->hoverTypeCombo->setCurrentText( "To Gray" );
    dialog_->effectsAmount_SpinBox->setValue( 5 );
    dialog_->activeHighlightClrBtn->setColor( QColor( 150, 150, 150 ) );
    dialog_->inActiveHighlightClrBtn->setColor( QColor( 150, 150, 150 ) );
    dialog_->decoColorizeComboBox->setCurrentText( "Liquid Method" );
    dialog_->buttonsColorizeComboBox->setCurrentText( "Liquid Method" );
    dialog_->buttonsHoverColorizeComboBox->setCurrentText( "Liquid Method" );

    // path's
    dialog_->framesPathKurl->setURL( "" );
    dialog_->buttonsPathKurl->setURL( "" );
    dialog_->useMasks_Chkbox->setChecked( config_->readBoolEntry( "UseMasks", FALSE ) );
    dialog_->masksPathKurl->setURL( "" );
}

//////////////////////////////////////////////////////////////////////////////
// themeSelected()
// ----------
//

void DeKoratorConfig::themeSelected( QListViewItem *item )
{
    themes_->themeSelected( item, dialog_->previewLabael );
}

//////////////////////////////////////////////////////////////////////////////
// installNewTheme()
// ----------
//

void DeKoratorConfig::installNewTheme()
{
    themes_->installNewTheme();
}

//////////////////////////////////////////////////////////////////////////////
// removeSelectedTheme()
// ----------
//

void DeKoratorConfig::removeSelectedTheme()
{
    themes_->removeSelectedTheme();
}

//////////////////////////////////////////////////////////////////////////////
// setTheme()
// ----------
//

void DeKoratorConfig::setTheme()
{
    themes_->setTheme( dialog_->framesPathKurl, dialog_->buttonsPathKurl, dialog_->masksPathKurl );
}

//////////////////////////////////////////////////////////////////////////////
// Plugin Stuff                                                             //
//////////////////////////////////////////////////////////////////////////////

extern "C"
{
    QObject * allocate_config( KConfig * config, QWidget * parent )
    {
        return ( new DeKoratorConfig( config, parent ) );
    }
}

#include "deKoratorconfig.moc"
