/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "ConfigEntry.h"
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>




struct _ConfigEntryPrivate {
	GtkEntry* entry;
};

#define CONFIG_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIG_ENTRY, ConfigEntryPrivate))
enum  {
	CONFIG_ENTRY_DUMMY_PROPERTY
};
static void config_entry_real_set_from_config (ConfigWidget* base);
static gboolean config_entry_handle_focus_out (ConfigEntry* self);
static gboolean _config_entry_handle_focus_out_gtk_widget_focus_out_event (GtkEntry* _sender, const GdkEventFocus* event, gpointer self);
static GObject * config_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer config_entry_parent_class = NULL;
static void config_entry_finalize (GObject* obj);



ConfigEntry* config_entry_construct (GType object_type, const char* key) {
	GParameter * __params;
	GParameter * __params_it;
	ConfigEntry * self;
	g_return_val_if_fail (key != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "key";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, key);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ConfigEntry* config_entry_new (const char* key) {
	return config_entry_construct (TYPE_CONFIG_ENTRY, key);
}


static void config_entry_real_set_from_config (ConfigWidget* base) {
	ConfigEntry * self;
	GError * inner_error;
	self = (ConfigEntry*) base;
	inner_error = NULL;
	{
		const char* _tmp0;
		char* val;
		_tmp0 = NULL;
		val = (_tmp0 = gconf_client_get_string (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), &inner_error), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
		if (inner_error != NULL) {
			goto __catch4_g_error;
			goto __finally4;
		}
		if (val == NULL) {
			char* _tmp1;
			_tmp1 = NULL;
			val = (_tmp1 = g_strdup (""), val = (g_free (val), NULL), _tmp1);
		}
		gtk_entry_set_text (self->priv->entry, val);
		val = (g_free (val), NULL);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigEntry.vala:47: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally4:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static gboolean config_entry_handle_focus_out (ConfigEntry* self) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, FALSE);
	inner_error = NULL;
	{
		gconf_client_set_string (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), gtk_entry_get_text (self->priv->entry), &inner_error);
		if (inner_error != NULL) {
			goto __catch5_g_error;
			goto __finally5;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigEntry.vala:57: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally5:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return FALSE;
}


static gboolean _config_entry_handle_focus_out_gtk_widget_focus_out_event (GtkEntry* _sender, const GdkEventFocus* event, gpointer self) {
	return config_entry_handle_focus_out (self);
}


static GObject * config_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ConfigEntryClass * klass;
	GObjectClass * parent_class;
	ConfigEntry * self;
	klass = CONFIG_ENTRY_CLASS (g_type_class_peek (TYPE_CONFIG_ENTRY));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CONFIG_ENTRY (obj);
	{
		GtkEntry* _tmp0;
		_tmp0 = NULL;
		self->priv->entry = (_tmp0 = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), (self->priv->entry == NULL) ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL)), _tmp0);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->entry);
		config_widget_set_from_config ((ConfigWidget*) self);
		g_signal_connect_object ((GtkWidget*) self->priv->entry, "focus-out-event", (GCallback) _config_entry_handle_focus_out_gtk_widget_focus_out_event, self, 0);
	}
	return obj;
}


static void config_entry_class_init (ConfigEntryClass * klass) {
	config_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ConfigEntryPrivate));
	G_OBJECT_CLASS (klass)->constructor = config_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = config_entry_finalize;
	CONFIG_WIDGET_CLASS (klass)->set_from_config = config_entry_real_set_from_config;
}


static void config_entry_instance_init (ConfigEntry * self) {
	self->priv = CONFIG_ENTRY_GET_PRIVATE (self);
}


static void config_entry_finalize (GObject* obj) {
	ConfigEntry * self;
	self = CONFIG_ENTRY (obj);
	(self->priv->entry == NULL) ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL));
	G_OBJECT_CLASS (config_entry_parent_class)->finalize (obj);
}


GType config_entry_get_type (void) {
	static GType config_entry_type_id = 0;
	if (config_entry_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigEntry), 0, (GInstanceInitFunc) config_entry_instance_init, NULL };
		config_entry_type_id = g_type_register_static (TYPE_CONFIG_WIDGET, "ConfigEntry", &g_define_type_info, 0);
	}
	return config_entry_type_id;
}




