/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include <RecursiveOp.h>
#include <gtk/gtk.h>




struct _DejaDupRecursiveOpPrivate {
	GFile* _src;
	GFile* _dst;
	gint ref_count;
};

#define DEJA_DUP_RECURSIVE_OP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpPrivate))
enum  {
	DEJA_DUP_RECURSIVE_OP_DUMMY_PROPERTY,
	DEJA_DUP_RECURSIVE_OP_SRC,
	DEJA_DUP_RECURSIVE_OP_DST
};
#define DEJA_DUP_RECURSIVE_OP_NUM_ENUMERATED 16
static void deja_dup_recursive_op_real_handle_file (DejaDupRecursiveOp* self);
static void deja_dup_recursive_op_real_handle_dir (DejaDupRecursiveOp* self);
static void deja_dup_recursive_op_real_finish_dir (DejaDupRecursiveOp* self);
static DejaDupRecursiveOp* deja_dup_recursive_op_real_clone_for_info (DejaDupRecursiveOp* self, GFileInfo* info);
static gboolean deja_dup_recursive_op_idle_action (DejaDupRecursiveOp* self);
static gboolean _deja_dup_recursive_op_idle_action_gsource_func (gpointer self);
static void __lambda2 (DejaDupRecursiveOp* m, DejaDupRecursiveOp* self);
static void ___lambda2_deja_dup_recursive_op_done (DejaDupRecursiveOp* _sender, gpointer self);
static void deja_dup_recursive_op_do_dir (DejaDupRecursiveOp* self);
static void _deja_dup_recursive_op_do_children_ready1_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void deja_dup_recursive_op_do_children (DejaDupRecursiveOp* self);
static void _deja_dup_recursive_op_do_children_ready2_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void deja_dup_recursive_op_do_children_ready1 (DejaDupRecursiveOp* self, GObject* obj, GAsyncResult* res);
static void _g_list_free_g_object_unref (GList* self);
static void __lambda0 (DejaDupRecursiveOp* m, DejaDupRecursiveOp* self);
static void ___lambda0_deja_dup_recursive_op_done (DejaDupRecursiveOp* _sender, gpointer self);
static void __lambda1 (DejaDupRecursiveOp* m, GFile* s, GFile* d, const char* e, DejaDupRecursiveOp* self);
static void ___lambda1_deja_dup_recursive_op_raise_error (DejaDupRecursiveOp* _sender, GFile* src, GFile* dst, const char* errstr, gpointer self);
static void deja_dup_recursive_op_do_children_ready2 (DejaDupRecursiveOp* self, GObject* obj, GAsyncResult* res);
static void deja_dup_recursive_op_add_ref (DejaDupRecursiveOp* self);
static void deja_dup_recursive_op_remove_ref (DejaDupRecursiveOp* self);
static void deja_dup_recursive_op_check_ref (DejaDupRecursiveOp* self);
static void deja_dup_recursive_op_set_src (DejaDupRecursiveOp* self, GFile* value);
static void deja_dup_recursive_op_set_dst (DejaDupRecursiveOp* self, GFile* value);
static gpointer deja_dup_recursive_op_parent_class = NULL;
static void deja_dup_recursive_op_finalize (GObject* obj);


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static void deja_dup_recursive_op_real_handle_file (DejaDupRecursiveOp* self) {
	g_return_if_fail (self != NULL);
}


void deja_dup_recursive_op_handle_file (DejaDupRecursiveOp* self) {
	DEJA_DUP_RECURSIVE_OP_GET_CLASS (self)->handle_file (self);
}


/* src is file*/
static void deja_dup_recursive_op_real_handle_dir (DejaDupRecursiveOp* self) {
	g_return_if_fail (self != NULL);
}


void deja_dup_recursive_op_handle_dir (DejaDupRecursiveOp* self) {
	DEJA_DUP_RECURSIVE_OP_GET_CLASS (self)->handle_dir (self);
}


/* src is dir*/
static void deja_dup_recursive_op_real_finish_dir (DejaDupRecursiveOp* self) {
	g_return_if_fail (self != NULL);
}


void deja_dup_recursive_op_finish_dir (DejaDupRecursiveOp* self) {
	DEJA_DUP_RECURSIVE_OP_GET_CLASS (self)->finish_dir (self);
}


static DejaDupRecursiveOp* deja_dup_recursive_op_real_clone_for_info (DejaDupRecursiveOp* self, GFileInfo* info) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `deja_dup_recursive_op_clone_for_info'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/* src is dir we are done with*/
DejaDupRecursiveOp* deja_dup_recursive_op_clone_for_info (DejaDupRecursiveOp* self, GFileInfo* info) {
	return DEJA_DUP_RECURSIVE_OP_GET_CLASS (self)->clone_for_info (self, info);
}


static gboolean deja_dup_recursive_op_idle_action (DejaDupRecursiveOp* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	deja_dup_recursive_op_start_async (self);
	return FALSE;
}


static gboolean _deja_dup_recursive_op_idle_action_gsource_func (gpointer self) {
	return deja_dup_recursive_op_idle_action (self);
}


static void __lambda2 (DejaDupRecursiveOp* m, DejaDupRecursiveOp* self) {
	g_return_if_fail (m != NULL);
	gtk_main_quit ();
}


static void ___lambda2_deja_dup_recursive_op_done (DejaDupRecursiveOp* _sender, gpointer self) {
	__lambda2 (_sender, self);
}


void deja_dup_recursive_op_start (DejaDupRecursiveOp* self) {
	g_return_if_fail (self != NULL);
	g_idle_add (_deja_dup_recursive_op_idle_action_gsource_func, self);
	g_signal_connect (self, "done", (GCallback) ___lambda2_deja_dup_recursive_op_done, self);
	gtk_main ();
}


void deja_dup_recursive_op_start_async (DejaDupRecursiveOp* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_src != NULL) {
		self->src_type = g_file_query_file_type (self->priv->_src, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
	}
	if (self->priv->_dst != NULL) {
		self->dst_type = g_file_query_file_type (self->priv->_dst, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
	}
	switch (self->src_type) {
		case G_FILE_TYPE_DIRECTORY:
		{
			deja_dup_recursive_op_do_dir (self);
			break;
		}
		default:
		{
			deja_dup_recursive_op_handle_file (self);
			break;
		}
	}
	deja_dup_recursive_op_check_ref (self);
}


static void deja_dup_recursive_op_do_dir (DejaDupRecursiveOp* self) {
	g_return_if_fail (self != NULL);
	deja_dup_recursive_op_handle_dir (self);
	/* Now descend*/
	deja_dup_recursive_op_add_ref (self);
	deja_dup_recursive_op_do_children (self);
}


static void _deja_dup_recursive_op_do_children_ready1_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	deja_dup_recursive_op_do_children_ready1 (self, source_object, res);
}


static void deja_dup_recursive_op_do_children (DejaDupRecursiveOp* self) {
	g_return_if_fail (self != NULL);
	g_file_enumerate_children_async (self->priv->_src, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, G_PRIORITY_DEFAULT, NULL, _deja_dup_recursive_op_do_children_ready1_gasync_ready_callback, self);
}


static void _deja_dup_recursive_op_do_children_ready2_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	deja_dup_recursive_op_do_children_ready2 (self, source_object, res);
}


static void deja_dup_recursive_op_do_children_ready1 (DejaDupRecursiveOp* self, GObject* obj, GAsyncResult* res) {
	GError * inner_error;
	GFileEnumerator* enumerator;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (res != NULL);
	inner_error = NULL;
	enumerator = NULL;
	{
		GFileEnumerator* _tmp0;
		GFileEnumerator* _tmp1;
		_tmp0 = g_file_enumerate_children_finish (self->priv->_src, res, &inner_error);
		if (inner_error != NULL) {
			goto __catch24_g_error;
			goto __finally24;
		}
		_tmp1 = NULL;
		enumerator = (_tmp1 = _tmp0, (enumerator == NULL) ? NULL : (enumerator = (g_object_unref (enumerator), NULL)), _tmp1);
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_signal_emit_by_name (self, "raise-error", self->priv->_src, self->priv->_dst, e->message);
			deja_dup_recursive_op_remove_ref (self);
			/* parent dir itself*/
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			(enumerator == NULL) ? NULL : (enumerator = (g_object_unref (enumerator), NULL));
			return;
		}
	}
	__finally24:
	if (inner_error != NULL) {
		(enumerator == NULL) ? NULL : (enumerator = (g_object_unref (enumerator), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	g_file_enumerator_next_files_async (enumerator, DEJA_DUP_RECURSIVE_OP_NUM_ENUMERATED, G_PRIORITY_DEFAULT, NULL, _deja_dup_recursive_op_do_children_ready2_gasync_ready_callback, self);
	(enumerator == NULL) ? NULL : (enumerator = (g_object_unref (enumerator), NULL));
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void __lambda0 (DejaDupRecursiveOp* m, DejaDupRecursiveOp* self) {
	g_return_if_fail (m != NULL);
	deja_dup_recursive_op_remove_ref (self);
	g_object_unref ((GObject*) m);
}


static void ___lambda0_deja_dup_recursive_op_done (DejaDupRecursiveOp* _sender, gpointer self) {
	__lambda0 (_sender, self);
}


static void __lambda1 (DejaDupRecursiveOp* m, GFile* s, GFile* d, const char* e, DejaDupRecursiveOp* self) {
	g_return_if_fail (m != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (e != NULL);
	g_signal_emit_by_name (self, "raise-error", s, d, e);
}


static void ___lambda1_deja_dup_recursive_op_raise_error (DejaDupRecursiveOp* _sender, GFile* src, GFile* dst, const char* errstr, gpointer self) {
	__lambda1 (_sender, src, dst, errstr, self);
}


static void deja_dup_recursive_op_do_children_ready2 (DejaDupRecursiveOp* self, GObject* obj, GAsyncResult* res) {
	GError * inner_error;
	GFileEnumerator* _tmp0;
	GFileEnumerator* enumerator;
	GList* infos;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (res != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	enumerator = (_tmp0 = G_FILE_ENUMERATOR (obj), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	infos = NULL;
	{
		GList* _tmp1;
		GList* _tmp2;
		_tmp1 = g_file_enumerator_next_files_finish (enumerator, res, &inner_error);
		if (inner_error != NULL) {
			goto __catch25_g_error;
			goto __finally25;
		}
		_tmp2 = NULL;
		infos = (_tmp2 = _tmp1, (infos == NULL) ? NULL : (infos = (_g_list_free_g_object_unref (infos), NULL)), _tmp2);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_signal_emit_by_name (self, "raise-error", self->priv->_src, self->priv->_dst, e->message);
			deja_dup_recursive_op_remove_ref (self);
			/* parent dir itself*/
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			(enumerator == NULL) ? NULL : (enumerator = (g_object_unref (enumerator), NULL));
			(infos == NULL) ? NULL : (infos = (_g_list_free_g_object_unref (infos), NULL));
			return;
		}
	}
	__finally25:
	if (inner_error != NULL) {
		(enumerator == NULL) ? NULL : (enumerator = (g_object_unref (enumerator), NULL));
		(infos == NULL) ? NULL : (infos = (_g_list_free_g_object_unref (infos), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	{
		GList* info_collection;
		GList* info_it;
		info_collection = infos;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GFileInfo* _tmp3;
			GFileInfo* info;
			_tmp3 = NULL;
			info = (_tmp3 = (GFileInfo*) info_it->data, (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3));
			{
				DejaDupRecursiveOp* op;
				deja_dup_recursive_op_add_ref (self);
				op = deja_dup_recursive_op_clone_for_info (self, info);
				g_object_ref ((GObject*) op);
				g_signal_connect (op, "done", (GCallback) ___lambda0_deja_dup_recursive_op_done, self);
				g_signal_connect (op, "raise-error", (GCallback) ___lambda1_deja_dup_recursive_op_raise_error, self);
				/* percolate up*/
				deja_dup_recursive_op_start_async (op);
				(info == NULL) ? NULL : (info = (g_object_unref (info), NULL));
				(op == NULL) ? NULL : (op = (g_object_unref (op), NULL));
			}
		}
	}
	if (g_list_length (infos) == DEJA_DUP_RECURSIVE_OP_NUM_ENUMERATED) {
		g_file_enumerator_next_files_async (enumerator, DEJA_DUP_RECURSIVE_OP_NUM_ENUMERATED, G_PRIORITY_DEFAULT, NULL, _deja_dup_recursive_op_do_children_ready2_gasync_ready_callback, self);
	} else {
		deja_dup_recursive_op_remove_ref (self);
	}
	(enumerator == NULL) ? NULL : (enumerator = (g_object_unref (enumerator), NULL));
	(infos == NULL) ? NULL : (infos = (_g_list_free_g_object_unref (infos), NULL));
}


/* parent dir itself*/
static void deja_dup_recursive_op_add_ref (DejaDupRecursiveOp* self) {
	g_return_if_fail (self != NULL);
	self->priv->ref_count = self->priv->ref_count + 1;
}


static void deja_dup_recursive_op_remove_ref (DejaDupRecursiveOp* self) {
	g_return_if_fail (self != NULL);
	self->priv->ref_count = self->priv->ref_count - 1;
	deja_dup_recursive_op_check_ref (self);
}


static void deja_dup_recursive_op_check_ref (DejaDupRecursiveOp* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->ref_count == 0) {
		if (self->src_type == G_FILE_TYPE_DIRECTORY) {
			deja_dup_recursive_op_finish_dir (self);
		}
		g_signal_emit_by_name (self, "done");
	}
}


GFile* deja_dup_recursive_op_get_src (DejaDupRecursiveOp* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_src;
}


static void deja_dup_recursive_op_set_src (DejaDupRecursiveOp* self, GFile* value) {
	GFile* _tmp2;
	GFile* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_src = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_src == NULL) ? NULL : (self->priv->_src = (g_object_unref (self->priv->_src), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "src");
}


GFile* deja_dup_recursive_op_get_dst (DejaDupRecursiveOp* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_dst;
}


static void deja_dup_recursive_op_set_dst (DejaDupRecursiveOp* self, GFile* value) {
	GFile* _tmp2;
	GFile* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_dst = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_dst == NULL) ? NULL : (self->priv->_dst = (g_object_unref (self->priv->_dst), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "dst");
}


static void deja_dup_recursive_op_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupRecursiveOp * self;
	gpointer boxed;
	self = DEJA_DUP_RECURSIVE_OP (object);
	switch (property_id) {
		case DEJA_DUP_RECURSIVE_OP_SRC:
		g_value_set_object (value, deja_dup_recursive_op_get_src (self));
		break;
		case DEJA_DUP_RECURSIVE_OP_DST:
		g_value_set_object (value, deja_dup_recursive_op_get_dst (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_recursive_op_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupRecursiveOp * self;
	self = DEJA_DUP_RECURSIVE_OP (object);
	switch (property_id) {
		case DEJA_DUP_RECURSIVE_OP_SRC:
		deja_dup_recursive_op_set_src (self, g_value_get_object (value));
		break;
		case DEJA_DUP_RECURSIVE_OP_DST:
		deja_dup_recursive_op_set_dst (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_recursive_op_class_init (DejaDupRecursiveOpClass * klass) {
	deja_dup_recursive_op_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupRecursiveOpPrivate));
	G_OBJECT_CLASS (klass)->get_property = deja_dup_recursive_op_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_recursive_op_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_recursive_op_finalize;
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->handle_file = deja_dup_recursive_op_real_handle_file;
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->handle_dir = deja_dup_recursive_op_real_handle_dir;
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->finish_dir = deja_dup_recursive_op_real_finish_dir;
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->clone_for_info = deja_dup_recursive_op_real_clone_for_info;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_RECURSIVE_OP_SRC, g_param_spec_object ("src", "src", "src", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_RECURSIVE_OP_DST, g_param_spec_object ("dst", "dst", "dst", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("done", DEJA_DUP_TYPE_RECURSIVE_OP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("raise_error", DEJA_DUP_TYPE_RECURSIVE_OP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING, G_TYPE_NONE, 3, G_TYPE_FILE, G_TYPE_FILE, G_TYPE_STRING);
}


static void deja_dup_recursive_op_instance_init (DejaDupRecursiveOp * self) {
	self->priv = DEJA_DUP_RECURSIVE_OP_GET_PRIVATE (self);
}


static void deja_dup_recursive_op_finalize (GObject* obj) {
	DejaDupRecursiveOp * self;
	self = DEJA_DUP_RECURSIVE_OP (obj);
	(self->priv->_src == NULL) ? NULL : (self->priv->_src = (g_object_unref (self->priv->_src), NULL));
	(self->priv->_dst == NULL) ? NULL : (self->priv->_dst = (g_object_unref (self->priv->_dst), NULL));
	G_OBJECT_CLASS (deja_dup_recursive_op_parent_class)->finalize (obj);
}


GType deja_dup_recursive_op_get_type (void) {
	static GType deja_dup_recursive_op_type_id = 0;
	if (deja_dup_recursive_op_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupRecursiveOpClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_recursive_op_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupRecursiveOp), 0, (GInstanceInitFunc) deja_dup_recursive_op_instance_init, NULL };
		deja_dup_recursive_op_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupRecursiveOp", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return deja_dup_recursive_op_type_id;
}



static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_STRING) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_string (param_values + 3), data2);
}



