/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include <RecursiveDelete.h>
#include <stdlib.h>
#include <string.h>




enum  {
	DEJA_DUP_RECURSIVE_DELETE_DUMMY_PROPERTY
};
static void deja_dup_recursive_delete_real_handle_file (DejaDupRecursiveOp* base);
static void deja_dup_recursive_delete_real_finish_dir (DejaDupRecursiveOp* base);
static DejaDupRecursiveOp* deja_dup_recursive_delete_real_clone_for_info (DejaDupRecursiveOp* base, GFileInfo* info);
static gpointer deja_dup_recursive_delete_parent_class = NULL;



DejaDupRecursiveDelete* deja_dup_recursive_delete_construct (GType object_type, GFile* source) {
	GParameter * __params;
	GParameter * __params_it;
	DejaDupRecursiveDelete * self;
	g_return_val_if_fail (source != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "src";
	g_value_init (&__params_it->value, G_TYPE_FILE);
	g_value_set_object (&__params_it->value, source);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DejaDupRecursiveDelete* deja_dup_recursive_delete_new (GFile* source) {
	return deja_dup_recursive_delete_construct (DEJA_DUP_TYPE_RECURSIVE_DELETE, source);
}


static void deja_dup_recursive_delete_real_handle_file (DejaDupRecursiveOp* base) {
	DejaDupRecursiveDelete * self;
	GError * inner_error;
	self = (DejaDupRecursiveDelete*) base;
	inner_error = NULL;
	{
		g_file_delete (deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch16_g_error;
			goto __finally16;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_signal_emit_by_name ((DejaDupRecursiveOp*) self, "raise-error", deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), deja_dup_recursive_op_get_dst ((DejaDupRecursiveOp*) self), e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally16:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void deja_dup_recursive_delete_real_finish_dir (DejaDupRecursiveOp* base) {
	DejaDupRecursiveDelete * self;
	GError * inner_error;
	self = (DejaDupRecursiveDelete*) base;
	inner_error = NULL;
	{
		g_file_delete (deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), NULL, &inner_error);
		if (inner_error != NULL) {
			goto __catch17_g_error;
			goto __finally17;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally17:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


/* will only be deleted if empty, so we won't
 accidentally toss files left over from a failed
 restore
 Ignore.  It's in /tmp, so it'll disappear, and most likely is just
 a non-empty directory.*/
static DejaDupRecursiveOp* deja_dup_recursive_delete_real_clone_for_info (DejaDupRecursiveOp* base, GFileInfo* info) {
	DejaDupRecursiveDelete * self;
	const char* _tmp0;
	char* child_name;
	GFile* src_child;
	DejaDupRecursiveOp* _tmp1;
	self = (DejaDupRecursiveDelete*) base;
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0 = NULL;
	child_name = (_tmp0 = g_file_info_get_name (info), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	src_child = g_file_get_child (deja_dup_recursive_op_get_src ((DejaDupRecursiveOp*) self), child_name);
	_tmp1 = NULL;
	return (_tmp1 = (DejaDupRecursiveOp*) deja_dup_recursive_delete_new (src_child), child_name = (g_free (child_name), NULL), (src_child == NULL) ? NULL : (src_child = (g_object_unref (src_child), NULL)), _tmp1);
}


static void deja_dup_recursive_delete_class_init (DejaDupRecursiveDeleteClass * klass) {
	deja_dup_recursive_delete_parent_class = g_type_class_peek_parent (klass);
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->handle_file = deja_dup_recursive_delete_real_handle_file;
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->finish_dir = deja_dup_recursive_delete_real_finish_dir;
	DEJA_DUP_RECURSIVE_OP_CLASS (klass)->clone_for_info = deja_dup_recursive_delete_real_clone_for_info;
}


static void deja_dup_recursive_delete_instance_init (DejaDupRecursiveDelete * self) {
}


GType deja_dup_recursive_delete_get_type (void) {
	static GType deja_dup_recursive_delete_type_id = 0;
	if (deja_dup_recursive_delete_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupRecursiveDeleteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_recursive_delete_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupRecursiveDelete), 0, (GInstanceInitFunc) deja_dup_recursive_delete_instance_init, NULL };
		deja_dup_recursive_delete_type_id = g_type_register_static (DEJA_DUP_TYPE_RECURSIVE_OP, "DejaDupRecursiveDelete", &g_define_type_info, 0);
	}
	return deja_dup_recursive_delete_type_id;
}




