/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "main.h"
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gio/gio.h>
#include "AssistantRestore.h"
#include "MainWindow.h"




GtkWindow* toplevel = NULL;
enum  {
	DEJA_DUP_APP_DUMMY_PROPERTY
};
static gboolean deja_dup_app_show_version = FALSE;
static gboolean deja_dup_app_restore_mode = FALSE;
static char** deja_dup_app_filenames = NULL;
static gint deja_dup_app_filenames_length1 = 0;
static gint deja_dup_app_filenames_size = 0;
static gboolean deja_dup_app_handle_console_options (gint* status);
static void __lambda0 (GtkWindow* t);
static void ___lambda0_gtk_object_destroy (GtkWindow* _sender, gpointer self);
static void _g_list_free_g_object_unref (GList* self);
static gpointer deja_dup_app_parent_class = NULL;
static void deja_dup_app_finalize (GObject* obj);

static const GOptionEntry DEJA_DUP_APP_options[] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &deja_dup_app_show_version, N_ ("Show version"), NULL}, {"restore", (gchar) 0, 0, G_OPTION_ARG_NONE, &deja_dup_app_restore_mode, N_ ("Restore given files"), NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &deja_dup_app_filenames, NULL, NULL}, {NULL}};


/* remaining*/
static gboolean deja_dup_app_handle_console_options (gint* status) {
	(*status) = 0;
	if (deja_dup_app_show_version) {
		g_print ("%s %s\n", _ ("Déjà Dup"), VERSION);
		return FALSE;
	}
	if (deja_dup_app_restore_mode) {
		if (deja_dup_app_filenames == NULL) {
			g_printerr ("%s\n", _ ("No filenames provided"));
			(*status) = 1;
			return FALSE;
		}
	}
	return TRUE;
}


static void __lambda0 (GtkWindow* t) {
	g_return_if_fail (t != NULL);
	gtk_main_quit ();
}


static void ___lambda0_gtk_object_destroy (GtkWindow* _sender, gpointer self) {
	__lambda0 (_sender);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


gint deja_dup_app_main (char** args, int args_length1) {
	GError * inner_error;
	GOptionContext* context;
	gint status;
	gint _tmp5;
	inner_error = NULL;
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	/* Translators: The name is a play on the French phrase "déjà vu" meaning
	 "already seen", but with the "vu" replaced with "dup".  "Dup" in this
	 context is itself a reference to both the underlying command line tool
	 "duplicity" and the act of duplicating data for backup.  As a whole, it
	 may not be very translatable.*/
	g_set_application_name (_ ("Déjà Dup"));
	context = g_option_context_new ("");
	g_option_context_add_main_entries (context, DEJA_DUP_APP_options, GETTEXT_PACKAGE);
	g_option_context_add_group (context, gtk_get_option_group (FALSE));
	{
		g_option_context_parse (context, &args_length1, &args, &inner_error);
		if (inner_error != NULL) {
			goto __catch11_g_error;
			goto __finally11;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp0;
			gint _tmp1;
			_tmp0 = NULL;
			g_printerr ("%s\n\n%s", e->message, _tmp0 = g_option_context_get_help (context, TRUE, NULL));
			_tmp0 = (g_free (_tmp0), NULL);
			return (_tmp1 = 1, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp1);
		}
	}
	__finally11:
	if (inner_error != NULL) {
		(context == NULL) ? NULL : (context = (g_option_context_free (context), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0;
	}
	status = 0;
	if (!deja_dup_app_handle_console_options (&status)) {
		gint _tmp2;
		return (_tmp2 = status, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp2);
	}
	gtk_init (&args_length1, &args);
	/* to open display ('cause we passed false above)*/
	gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (), THEME_DIR);
	gtk_window_set_default_icon_name (PACKAGE);
	if (deja_dup_app_restore_mode) {
		GList* file_list;
		gint i;
		GtkWindow* _tmp3;
		file_list = NULL;
		i = 0;
		while (deja_dup_app_filenames[i] != NULL) {
			file_list = g_list_append (file_list, g_file_new_for_commandline_arg (deja_dup_app_filenames[i++]));
		}
		_tmp3 = NULL;
		toplevel = (_tmp3 = (GtkWindow*) g_object_ref_sink (assistant_restore_new_with_files (file_list)), (toplevel == NULL) ? NULL : (toplevel = (g_object_unref (toplevel), NULL)), _tmp3);
		g_signal_connect ((GtkObject*) toplevel, "destroy", (GCallback) ___lambda0_gtk_object_destroy, NULL);
		(file_list == NULL) ? NULL : (file_list = (_g_list_free_g_object_unref (file_list), NULL));
	} else {
		GtkWindow* _tmp4;
		_tmp4 = NULL;
		toplevel = (_tmp4 = (GtkWindow*) g_object_ref_sink (main_window_new ()), (toplevel == NULL) ? NULL : (toplevel = (g_object_unref (toplevel), NULL)), _tmp4);
	}
	gtk_widget_show_all ((GtkWidget*) toplevel);
	gtk_main ();
	return (_tmp5 = 0, (context == NULL) ? NULL : (context = (g_option_context_free (context), NULL)), _tmp5);
}


int main (int argc, char ** argv) {
	g_type_init ();
	return deja_dup_app_main (argv, argc);
}


DejaDupApp* deja_dup_app_construct (GType object_type) {
	DejaDupApp * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DejaDupApp* deja_dup_app_new (void) {
	return deja_dup_app_construct (TYPE_DEJA_DUP_APP);
}


static void deja_dup_app_class_init (DejaDupAppClass * klass) {
	deja_dup_app_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = deja_dup_app_finalize;
}


static void deja_dup_app_instance_init (DejaDupApp * self) {
}


static void deja_dup_app_finalize (GObject* obj) {
	DejaDupApp * self;
	self = DEJA_DUP_APP (obj);
	G_OBJECT_CLASS (deja_dup_app_parent_class)->finalize (obj);
}


GType deja_dup_app_get_type (void) {
	static GType deja_dup_app_type_id = 0;
	if (deja_dup_app_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupApp), 0, (GInstanceInitFunc) deja_dup_app_instance_init, NULL };
		deja_dup_app_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupApp", &g_define_type_info, 0);
	}
	return deja_dup_app_type_id;
}




