/* CommonUtils.c generated by valac, the Vala compiler
 * generated from CommonUtils.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gconf/gconf-client.h>
#include <gio/gio.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gconf/gconf.h>
#include <glib/gi18n-lib.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gconf_engine_unref0(var) ((var == NULL) ? NULL : (var = (gconf_engine_unref (var), NULL)))

#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;


extern GConfClient* deja_dup_client;
GConfClient* deja_dup_client = NULL;

#define DEJA_DUP_GCONF_DIR "/apps/deja-dup"
#define DEJA_DUP_INCLUDE_LIST_KEY "/apps/deja-dup/include-list"
#define DEJA_DUP_EXCLUDE_LIST_KEY "/apps/deja-dup/exclude-list"
#define DEJA_DUP_BACKEND_KEY "/apps/deja-dup/backend"
#define DEJA_DUP_ROOT_PROMPT_KEY "/apps/deja-dup/root-prompt"
#define DEJA_DUP_ENCRYPT_KEY "/apps/deja-dup/encrypt"
#define DEJA_DUP_LAST_RUN_KEY "/apps/deja-dup/last-run"
#define DEJA_DUP_PERIODIC_KEY "/apps/deja-dup/periodic"
#define DEJA_DUP_PERIODIC_PERIOD_KEY "/apps/deja-dup/periodic-period"
#define DEJA_DUP_DELETE_AFTER_KEY "/apps/deja-dup/delete-after"
GConfClient* deja_dup_get_gconf_client (void);
void deja_dup_update_last_run_timestamp (GError** error);
char* deja_dup_get_trash_path (void);
GFile* deja_dup_parse_dir (const char* dir);
GFile** deja_dup_parse_dir_list (GSList* dirs, int* result_length1);
static char* _dynamic_get_name_owner0 (DBusGProxy* self, char* param1, GError** error);
gboolean deja_dup_test_bus_claimed (const char* busname);
static guint32 _dynamic_request_name1 (DBusGProxy* self, char* param1, guint32 param2, GError** error);
static guint32 _dynamic_release_name2 (DBusGProxy* self, char* param1, GError** error);
gboolean deja_dup_set_bus_claimed (const char* busname, gboolean claim);
void deja_dup_set_gconf_client (void);
#define DEJA_DUP_SSH_USERNAME_KEY "/apps/deja-dup/ssh/username"
#define DEJA_DUP_SSH_SERVER_KEY "/apps/deja-dup/ssh/server"
#define DEJA_DUP_SSH_PORT_KEY "/apps/deja-dup/ssh/port"
#define DEJA_DUP_SSH_DIRECTORY_KEY "/apps/deja-dup/ssh/directory"
#define DEJA_DUP_FILE_PATH_KEY "/apps/deja-dup/file/path"
void deja_dup_convert_ssh_to_file (void);
void deja_dup_initialize (void);
char* deja_dup_get_file_desc (GFile* file);
GType deja_dup_backend_get_type (void);
DejaDupBackend* deja_dup_backend_get_default (GError** error);
char* deja_dup_backend_get_location_pretty (DejaDupBackend* self, GError** error);
char* deja_dup_get_location_desc (void);
gint deja_dup_get_full_backup_threshold (void);
void deja_dup_get_full_backup_threshold_date (GDate* result);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



void deja_dup_update_last_run_timestamp (GError** error) {
	GError * _inner_error_;
	GTimeVal cur_time = {0};
	char* cur_time_str;
	GConfClient* client;
	_inner_error_ = NULL;
	g_get_current_time (&cur_time);
	g_get_current_time (&cur_time);
	cur_time_str = g_time_val_to_iso8601 (&cur_time);
	client = deja_dup_get_gconf_client ();
	gconf_client_set_string (client, DEJA_DUP_LAST_RUN_KEY, cur_time_str, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (cur_time_str);
		_g_object_unref0 (client);
		return;
	}
	_g_free0 (cur_time_str);
	_g_object_unref0 (client);
}


char* deja_dup_get_trash_path (void) {
	char* result = NULL;
	result = g_build_filename (g_get_user_data_dir (), "Trash", NULL);
	return result;
}


GFile* deja_dup_parse_dir (const char* dir) {
	GFile* result = NULL;
	char* s;
	g_return_val_if_fail (dir != NULL, NULL);
	s = g_strdup (dir);
	if (_vala_strcmp0 (s, "$HOME") == 0) {
		char* _tmp0_;
		s = (_tmp0_ = g_strdup (g_get_home_dir ()), _g_free0 (s), _tmp0_);
	} else {
		if (_vala_strcmp0 (s, "$DESKTOP") == 0) {
			char* _tmp1_;
			s = (_tmp1_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP)), _g_free0 (s), _tmp1_);
		} else {
			if (_vala_strcmp0 (s, "$DOCUMENTS") == 0) {
				char* _tmp2_;
				s = (_tmp2_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS)), _g_free0 (s), _tmp2_);
			} else {
				if (_vala_strcmp0 (s, "$DOWNLOAD") == 0) {
					char* _tmp3_;
					s = (_tmp3_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD)), _g_free0 (s), _tmp3_);
				} else {
					if (_vala_strcmp0 (s, "$MUSIC") == 0) {
						char* _tmp4_;
						s = (_tmp4_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_MUSIC)), _g_free0 (s), _tmp4_);
					} else {
						if (_vala_strcmp0 (s, "$PICTURES") == 0) {
							char* _tmp5_;
							s = (_tmp5_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_PICTURES)), _g_free0 (s), _tmp5_);
						} else {
							if (_vala_strcmp0 (s, "$PUBLIC_SHARE") == 0) {
								char* _tmp6_;
								s = (_tmp6_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_PUBLIC_SHARE)), _g_free0 (s), _tmp6_);
							} else {
								if (_vala_strcmp0 (s, "$TEMPLATES") == 0) {
									char* _tmp7_;
									s = (_tmp7_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_TEMPLATES)), _g_free0 (s), _tmp7_);
								} else {
									if (_vala_strcmp0 (s, "$TRASH") == 0) {
										char* _tmp8_;
										s = (_tmp8_ = deja_dup_get_trash_path (), _g_free0 (s), _tmp8_);
									} else {
										if (_vala_strcmp0 (s, "$VIDEOS") == 0) {
											char* _tmp9_;
											s = (_tmp9_ = g_strdup (g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS)), _g_free0 (s), _tmp9_);
										} else {
											if (!g_path_is_absolute (s)) {
												char* _tmp10_;
												s = (_tmp10_ = g_build_filename (g_get_home_dir (), s, NULL), _g_free0 (s), _tmp10_);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = g_file_new_for_path (s);
	_g_free0 (s);
	return result;
}


GFile** deja_dup_parse_dir_list (GSList* dirs, int* result_length1) {
	GFile** result = NULL;
	GFile** _tmp2_;
	gint _rv_size_;
	gint rv_length1;
	gint _tmp1_;
	GFile** rv;
	gint i;
	GFile** _tmp5_;
	if (dirs == NULL) {
		GFile** _tmp0_;
		result = (_tmp0_ = g_new0 (GFile*, 0 + 1), *result_length1 = 0, _tmp0_);
		return result;
	}
	rv = (_tmp2_ = g_new0 (GFile*, (_tmp1_ = g_slist_length (dirs)) + 1), rv_length1 = _tmp1_, _rv_size_ = rv_length1, _tmp2_);
	i = 0;
	{
		GSList* s_collection;
		GSList* s_it;
		s_collection = dirs;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			char* s;
			s = g_strdup ((const char*) s_it->data);
			{
				GFile* _tmp4_;
				GFile* *_tmp3_;
				_tmp3_ = &rv[i++];
				(*_tmp3_) = (_tmp4_ = deja_dup_parse_dir (s), _g_object_unref0 ((*_tmp3_)), _tmp4_);
				_g_free0 (s);
			}
		}
	}
	result = (_tmp5_ = rv, *result_length1 = rv_length1, _tmp5_);
	return result;
	rv = (_vala_array_free (rv, rv_length1, (GDestroyNotify) g_object_unref), NULL);
}


static char* _dynamic_get_name_owner0 (DBusGProxy* self, char* param1, GError** error) {
	char* result;
	dbus_g_proxy_call (self, "GetNameOwner", error, G_TYPE_STRING, param1, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


gboolean deja_dup_test_bus_claimed (const char* busname) {
	gboolean result = FALSE;
	GError * _inner_error_;
	g_return_val_if_fail (busname != NULL, FALSE);
	_inner_error_ = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* bus;
		char* _tmp0_;
		char* _tmp1_;
		char* _result_;
		gboolean _tmp2_ = FALSE;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
		_result_ = (_tmp1_ = _dynamic_get_name_owner0 (bus, _tmp0_ = g_strconcat ("net.launchpad.deja-dup.", busname, NULL), &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			_dbus_g_connection_unref0 (conn);
			_g_object_unref0 (bus);
			goto __catch10_g_error;
		}
		if (_result_ != NULL) {
			_tmp2_ = _vala_strcmp0 (_result_, "") != 0;
		} else {
			_tmp2_ = FALSE;
		}
		result = _tmp2_;
		_dbus_g_connection_unref0 (conn);
		_g_object_unref0 (bus);
		_g_free0 (_result_);
		return result;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally10:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
}


static guint32 _dynamic_request_name1 (DBusGProxy* self, char* param1, guint32 param2, GError** error) {
	guint32 result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


static guint32 _dynamic_release_name2 (DBusGProxy* self, char* param1, GError** error) {
	guint32 result;
	dbus_g_proxy_call (self, "ReleaseName", error, G_TYPE_STRING, param1, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


gboolean deja_dup_set_bus_claimed (const char* busname, gboolean claim) {
	gboolean result = FALSE;
	GError * _inner_error_;
	g_return_val_if_fail (busname != NULL, FALSE);
	_inner_error_ = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* bus;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
		if (claim) {
			char* _tmp0_;
			guint32 _tmp1_;
			guint32 _result_;
			_result_ = (_tmp1_ = _dynamic_request_name1 (bus, _tmp0_ = g_strconcat ("net.launchpad.deja-dup.", busname, NULL), (guint32) 4, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
			if (_inner_error_ != NULL) {
				_dbus_g_connection_unref0 (conn);
				_g_object_unref0 (bus);
				goto __catch11_g_error;
			}
			if (_result_ == DBUS_REQUEST_NAME_REPLY_EXISTS) {
				result = FALSE;
				_dbus_g_connection_unref0 (conn);
				_g_object_unref0 (bus);
				return result;
			}
		} else {
			char* _tmp2_;
			guint32 _tmp3_;
			guint32 _result_;
			_result_ = (_tmp3_ = _dynamic_release_name2 (bus, _tmp2_ = g_strconcat ("net.launchpad.deja-dup.", busname, NULL), &_inner_error_), _g_free0 (_tmp2_), _tmp3_);
			if (_inner_error_ != NULL) {
				_dbus_g_connection_unref0 (conn);
				_g_object_unref0 (bus);
				goto __catch11_g_error;
			}
			if (_result_ != 1) {
				g_warning ("CommonUtils.vala:134: Unexpected reply of %u when releasing busname %s" \
"\n", (guint) _result_, busname);
			}
		}
		_dbus_g_connection_unref0 (conn);
		_g_object_unref0 (bus);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("CommonUtils.vala:138: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void deja_dup_set_gconf_client (void) {
	GError * _inner_error_;
	char* source_str;
	_inner_error_ = NULL;
	source_str = g_strdup (g_getenv ("GCONF_CONFIG_SOURCE"));
	if (source_str != NULL) {
		{
			GConfEngine* _tmp0_;
			GConfEngine* engine;
			GConfClient* _tmp1_;
			engine = (_tmp0_ = gconf_engine_get_for_address (source_str, &_inner_error_), (_tmp0_ == NULL) ? NULL : gconf_engine_ref (_tmp0_), _tmp0_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
			deja_dup_client = (_tmp1_ = _g_object_ref0 (gconf_client_get_for_engine (engine)), _g_object_unref0 (deja_dup_client), _tmp1_);
			_gconf_engine_unref0 (engine);
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_printerr ("%s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally12:
		if (_inner_error_ != NULL) {
			_g_free0 (source_str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (source_str);
}


GConfClient* deja_dup_get_gconf_client (void) {
	GConfClient* result = NULL;
	if (deja_dup_client == NULL) {
		GConfClient* _tmp0_;
		deja_dup_client = (_tmp0_ = _g_object_ref0 (gconf_client_get_default ()), _g_object_unref0 (deja_dup_client), _tmp0_);
	}
	result = _g_object_ref0 (deja_dup_client);
	return result;
}


void deja_dup_convert_ssh_to_file (void) {
	GError * _inner_error_;
	GConfClient* client;
	_inner_error_ = NULL;
	client = deja_dup_get_gconf_client ();
	{
		char* backend;
		backend = gconf_client_get_string (client, DEJA_DUP_BACKEND_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		if (_vala_strcmp0 (backend, "ssh") == 0) {
			char* server;
			gboolean _tmp0_ = FALSE;
			gconf_client_set_string (client, DEJA_DUP_BACKEND_KEY, "file", &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (backend);
				goto __catch13_g_error;
			}
			server = gconf_client_get_string (client, DEJA_DUP_SSH_SERVER_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (backend);
				goto __catch13_g_error;
			}
			if (server != NULL) {
				_tmp0_ = _vala_strcmp0 (server, "") != 0;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				char* username;
				gint port;
				char* directory;
				char* gio_uri;
				gboolean _tmp1_ = FALSE;
				char* _tmp4_;
				gboolean _tmp8_ = FALSE;
				username = gconf_client_get_string (client, DEJA_DUP_SSH_USERNAME_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (server);
					_g_free0 (backend);
					goto __catch13_g_error;
				}
				port = gconf_client_get_int (client, DEJA_DUP_SSH_PORT_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (username);
					_g_free0 (server);
					_g_free0 (backend);
					goto __catch13_g_error;
				}
				directory = gconf_client_get_string (client, DEJA_DUP_SSH_DIRECTORY_KEY, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (username);
					_g_free0 (server);
					_g_free0 (backend);
					goto __catch13_g_error;
				}
				gio_uri = g_strdup ("ssh://");
				if (username != NULL) {
					_tmp1_ = _vala_strcmp0 (username, "") != 0;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					char* _tmp3_;
					char* _tmp2_;
					gio_uri = (_tmp3_ = g_strconcat (gio_uri, _tmp2_ = g_strconcat (username, "@", NULL), NULL), _g_free0 (gio_uri), _tmp3_);
					_g_free0 (_tmp2_);
				}
				gio_uri = (_tmp4_ = g_strconcat (gio_uri, server, NULL), _g_free0 (gio_uri), _tmp4_);
				if (port > 0) {
					char* _tmp7_;
					char* _tmp6_;
					char* _tmp5_;
					gio_uri = (_tmp7_ = g_strconcat (gio_uri, _tmp6_ = g_strconcat (":", _tmp5_ = g_strdup_printf ("%i", port), NULL), NULL), _g_free0 (gio_uri), _tmp7_);
					_g_free0 (_tmp6_);
					_g_free0 (_tmp5_);
				}
				if (directory == NULL) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = _vala_strcmp0 (directory, "") == 0;
				}
				if (_tmp8_) {
					char* _tmp9_;
					gio_uri = (_tmp9_ = g_strconcat (gio_uri, "/", NULL), _g_free0 (gio_uri), _tmp9_);
				} else {
					if (g_utf8_get_char (g_utf8_offset_to_pointer (directory, 0)) != '/') {
						char* _tmp11_;
						char* _tmp10_;
						gio_uri = (_tmp11_ = g_strconcat (gio_uri, _tmp10_ = g_strconcat ("/", directory, NULL), NULL), _g_free0 (gio_uri), _tmp11_);
						_g_free0 (_tmp10_);
					} else {
						char* _tmp12_;
						gio_uri = (_tmp12_ = g_strconcat (gio_uri, directory, NULL), _g_free0 (gio_uri), _tmp12_);
					}
				}
				gconf_client_set_string (client, DEJA_DUP_FILE_PATH_KEY, gio_uri, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (username);
					_g_free0 (directory);
					_g_free0 (gio_uri);
					_g_free0 (server);
					_g_free0 (backend);
					goto __catch13_g_error;
				}
				_g_free0 (username);
				_g_free0 (directory);
				_g_free0 (gio_uri);
			}
			_g_free0 (server);
		}
		_g_free0 (backend);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("CommonUtils.vala:205: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (client);
}


void deja_dup_initialize (void) {
	deja_dup_set_gconf_client ();
	deja_dup_convert_ssh_to_file ();
}


char* deja_dup_get_file_desc (GFile* file) {
	char* result = NULL;
	GError * _inner_error_;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	_inner_error_ = NULL;
	{
		GFileInfo* info;
		info = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		if (g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION)) {
			result = g_strdup (g_file_info_get_attribute_string (info, G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION));
			_g_object_unref0 (info);
			return result;
		} else {
			if (g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME)) {
				result = g_strdup (g_file_info_get_attribute_string (info, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME));
				_g_object_unref0 (info);
				return result;
			}
		}
		_g_object_unref0 (info);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = (_tmp1_ = g_path_get_basename (_tmp0_ = g_file_get_parse_name (file)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


char* deja_dup_get_location_desc (void) {
	char* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		DejaDupBackend* _tmp0_;
		DejaDupBackend* _tmp1_;
		char* _tmp2_;
		char* desc;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = deja_dup_backend_get_default (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		desc = (_tmp2_ = deja_dup_backend_get_location_pretty (_tmp1_ = _tmp0_, &_inner_error_), _g_object_unref0 (_tmp1_), _tmp2_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		if (desc != NULL) {
			_tmp3_ = _vala_strcmp0 (desc, "") != 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = desc;
			return result;
		}
		_g_free0 (desc);
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = g_strdup (_ ("Unknown"));
	return result;
}


gint deja_dup_get_full_backup_threshold (void) {
	gint result = 0;
	GError * _inner_error_;
	gint threshold;
	_inner_error_ = NULL;
	threshold = 7 * 6;
	{
		gint max;
		gint min;
		gint scale;
		gint min_fulls;
		gint delete_age;
		gboolean periodic;
		max = 24 * 7;
		min = 4 * 7;
		scale = 12;
		min_fulls = 2;
		delete_age = gconf_client_get_int (deja_dup_client, DEJA_DUP_DELETE_AFTER_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		if (delete_age > 0) {
			max = MIN (delete_age / min_fulls, max);
		}
		periodic = gconf_client_get_bool (deja_dup_client, DEJA_DUP_PERIODIC_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		if (periodic) {
			gint period;
			period = gconf_client_get_int (deja_dup_client, DEJA_DUP_PERIODIC_PERIOD_KEY, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch16_g_error;
			}
			threshold = period * scale;
			CLAMP (threshold, min, max);
		} else {
			threshold = max;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("CommonUtils.vala:283: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = threshold;
	return result;
}


void deja_dup_get_full_backup_threshold_date (GDate* result) {
	GTimeVal now = {0};
	GDate date = {0};
	gint days;
	g_get_current_time (&now);
	g_get_current_time (&now);
	memset (&date, 0, sizeof (GDate));
	g_date_set_time_val (&date, &now);
	days = deja_dup_get_full_backup_threshold ();
	g_date_subtract_days (&date, (guint) days);
	*result = date;
	return;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




