/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _DECIBEL_DAEMON_KDE4_ACCOUNTCONNECTOR_H
#define _DECIBEL_DAEMON_KDE4_ACCOUNTCONNECTOR_H

#include "accountconnectorbase.h"
#include "accountconnector.h"

#include <QtCore/QHash>

/// @cond FALSE

/**
 * @brief A simplistic implementation of the account connector interface.
 *
 * @author Tobias Hunger <info@basyskom.de>
 */
class AccountConnector : public AccountConnectorBase
{
public:
    AccountConnector();

    ~AccountConnector();

    bool hasAccount(const uint id) const;
    uint storeAccount(const QVariantMap & nv_pairs);
    void updateAccount(const uint id, const QVariantMap & nv_pairs);
    QVariantMap getAccount(const uint id) const;
    bool deleteAccount(const uint id);
    QList<uint> accountIds() const;
    QList<uint> findAccounts(const QVariantMap & nv_pairs) const;
    bool setValue(const uint id, const QString & key, const QVariant & value);

private:
    QHash<uint, QVariantMap> m_accounts;
    uint m_currentHandle;
};

/// @endcond

#endif
