# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Francois.Ingelrest@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import cgi, gtk, modules

from tools import consts, prefs, sec2str

MOD_INFO = ('Track Panel', 'Track Panel', '', [], True, False)


class TrackPanel(modules.Module):
    """ This module manages the panel showing information on the current track """

    def __init__(self):
        """ Constructor """
        modules.Module.__init__(self, (consts.MSG_EVT_STOPPED, consts.MSG_EVT_NEW_TRACK, consts.MSG_EVT_APP_STARTED, consts.MSG_CMD_SET_COVER))


    def onAppStarted(self):
        """ Real initialization function, called when this module has been loaded """
        # Widgets
        wTree          = prefs.getWidgetsTree()
        self.img       = wTree.get_widget('img-cover')
        self.txtMisc   = wTree.get_widget('lbl-trkMisc')
        self.txtTitle  = wTree.get_widget('lbl-trkTitle')
        self.imgFrame  = wTree.get_widget('frm-cover')
        self.currTrack = None
        # Initial state
        self.onStopped()


    def __setTitle(self, title, length=None):
        """ Change the title of the current track """
        title = cgi.escape(title)

        if length is None: self.txtTitle.set_markup('<span size="larger"><b>%s</b></span>' % title)
        else:              self.txtTitle.set_markup('<span size="larger"><b>%s</b></span>  [%s]' % (title, sec2str(length)))


    def __setImage(self, imgPath):
        """ Change the current image, use the application's icon if imgPath is None """
        if imgPath is None:
            self.img.set_from_file(consts.fileImgIcon64)
            self.imgFrame.set_shadow_type(gtk.SHADOW_NONE)
        else:
            self.img.set_from_file(imgPath)
            self.imgFrame.set_shadow_type(gtk.SHADOW_IN)


    def onNewTrack(self, track):
        """ A new track is being played """
        self.currTrack = track
        self.__setTitle(track.getTitle(), track.getLength())
        self.txtMisc.set_text('by %s\nfrom %s' % (track.getArtist(), track.getExtendedAlbum()))


    def onStopped(self):
        """ Playback has been stopped """
        self.currTrack = None
        self.__setTitle(consts.appName)
        self.txtMisc.set_text('...And Music For All')
        self.__setImage(None)


    # --== GTK handlers ==--


   # --== Message handler ==--


    def handleMsg(self, msg, params):
        """ Handle messages sent to this module """
        if msg == consts.MSG_EVT_STOPPED:
            self.onStopped()
        elif msg == consts.MSG_EVT_NEW_TRACK:
            self.onNewTrack(params['track'])
        elif msg == consts.MSG_EVT_APP_STARTED:
            self.onAppStarted()
        elif msg == consts.MSG_CMD_SET_COVER:
            coverPath  = params['path']
            coverTrack = params['track']

            # Make sure that the track is the correct one
            if self.currTrack is not None and self.currTrack.getArtist() == coverTrack.getArtist() \
                and self.currTrack.getAlbum() == coverTrack.getAlbum():
                    self.__setImage(coverPath)
