# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import media

from tools       import consts
from mutagen.mp3 import MP3
from mutagen.id3 import ID3, ID3NoHeaderError


def readInfo(file):
    """
        Read information from a mp3 file
    """
    info = [consts.UNKNOWN_TRACKNUMBER, consts.UNKNOWN_TITLE, consts.UNKNOWN_ARTIST, consts.UNKNOWN_ALBUM, consts.UNKNOWN_LENGTH, file]

    try:
        mp3File = ID3(file)
    except ID3NoHeaderError:
        return info

    if 'TIT2' in mp3File: info[media.NFO_TIT] = str(mp3File['TIT2'])
    if 'TALB' in mp3File: info[media.NFO_ALB] = str(mp3File['TALB'])
    if 'TPE1' in mp3File: info[media.NFO_ART] = str(mp3File['TPE1'])
    if 'TRCK' in mp3File: info[media.NFO_NUM] = int(str(mp3File['TRCK']).split('/')[0])  # Track format may sometimes be 01/08, 02/08...

    info[media.NFO_LEN] = int(MP3(file).info.length)

    return info
