#!/usr/bin/env python
#
# Written by Bram Cohen
# Modified by Cameron Dale
# see LICENSE.txt for license information
#
# $Id: setup.py 366 2008-01-28 04:39:22Z camrdale-guest $

"""The DebTorrent program for downloading debian packages.

This program contains several scripts and packages to implement the debtorrent
protocol for downloading debian packages from an archive is a bittorrent-like
way.

"""

import sys
assert sys.version_info >= (2,3), "Install Python 2.3 or greater"
from distutils.core import setup, Extension
import DebTorrent

setup(
    name = "DebTorrent",
    version = DebTorrent.version,
    author = "Cameron Dale",
    author_email = "<debtorrent-devel@lists.alioth.debian.org>",
    url = "http://debtorrent.alioth.debian.org",
    license = "MIT",
    
    packages = ["DebTorrent","DebTorrent.BT1"],

    scripts = ["btmakemetafile.py", "btcompletedir.py", "btreannounce.py", 
               "btrename.py", "btshowmetainfo.py", 'btcopyannounce.py',
               'btsetdebmirrors.py', 'test.py', 'hippy.py', 'uniquely.py',
               'debtorrent-client.py', 'debtorrent-tracker.py',
               'split_cache_for_all.py'
        ]
    )
