# SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
# SPDX-License-Identifier: GPL-2.0-or-later
"""Unit tests for the output of `debsigs --features`."""

from __future__ import annotations

import subprocess  # noqa: S404
import typing

from .util import test_cfg  # noqa: F401  # pytest fixture


if typing.TYPE_CHECKING:
    from typing import Final

    from . import util


def test_version(test_cfg: util.ConfigAggr) -> None:  # noqa: F811  # pytest fixture
    """Make sure `debsigs --version` and `debsigs --features` agree."""
    with test_cfg.cfg_with_tempd() as cfg:
        ver: Final = test_cfg.debsigs_features["debsigs"].value
        assert subprocess.check_output(  # noqa: S603
            [cfg.prog.debsigs, "--version"],
            cwd=cfg.path.work,
            encoding="UTF-8",
            env=cfg.env,
        ).splitlines() == [f"debsigs v{ver}"]
