<?xml version="1.0" encoding="iso-8859-1" ?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">
<!ENTITY copy "&#169;">]>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="iso-8859-1" doctype-public="-//W3C//DTD
HTML 4.01 Transitional//EN&quot; &quot;http://www.w3.org/TR/html4/loose.dtd" />

<!--
 Copyright (C) Jaime Villate <villate@gnu.org>, 2001

 Stylesheet to parse "recipes" from http://www.laespiral.org

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 $Id: LE-receta.xsl,v 1.2 2001/12/05 21:42:14 villate Exp $
-->

<xsl:template match="receta">
  <html>
  <head>
  <title>
  <xsl:text>La Espiral - </xsl:text><xsl:value-of select="titulo"/>
  </title>
  </head>
  <body bgcolor="#ffffff">
  <div align="center">
  <xsl:apply-templates select="titulo"/>
  <br/>
  <xsl:for-each select="autor">
  <xsl:apply-templates/>.
  </xsl:for-each>
  <xsl:apply-templates select="fecha"/>
  <xsl:apply-templates select="version"/>
  </div>
  <table border="0" bgcolor="#cccccc" cellspacing="0">
  <xsl:apply-templates select="nivel"/>
  <xsl:apply-templates select="sistema"/>
  <xsl:apply-templates select="arquitectura"/>
  <xsl:apply-templates select="distribucion"/>
  <xsl:apply-templates select="seccion"/>
  <xsl:apply-templates select="funcion"/>
  </table>
  <xsl:apply-templates select="contenido"/>
  <p><small>&copy; 2001, <a href="http://www.laespiral.org">La Espiral</a>.
  </small></p>
  </body>
  </html>
</xsl:template>

<xsl:template match="nivel">
<tr><td><b>Nivel:</b></td><td><xsl:value-of select="@valor"/></td></tr>
</xsl:template>

<xsl:template match="sistema">
<tr><td><b>Sistema:</b></td><td><xsl:value-of select="@valor"/></td></tr>
</xsl:template>

<xsl:template match="arquitectura">
<tr><td><b>Arquitectura:</b></td><td><xsl:value-of select="@valor"/></td></tr>
</xsl:template>

<xsl:template match="distribucion">
<tr><td><b>Distribucin:</b></td><td><xsl:value-of select="@valor"/></td></tr>
</xsl:template>

<xsl:template match="seccion">
<tr><td><b>Seccin:</b></td><td><xsl:value-of select="@valor"/></td></tr>
</xsl:template>

<xsl:template match="funcion">
<tr><td><b>Funcin:</b></td><td><xsl:value-of select="@valor"/></td></tr>
</xsl:template>

<xsl:template match="secc1">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="secc1/titulo">
  <h2><xsl:apply-templates/></h2>
</xsl:template>

<xsl:template match="secc1/titulo" mode="crossref">
  <i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="secc1/titulo">
  <xsl:element name="h2">
  <xsl:choose>
  <xsl:when test="ancestor::secc1[@id]">
  <xsl:element name="a">
  <xsl:attribute name="name">
  <xsl:value-of select="ancestor::secc1/@id"/>
  </xsl:attribute>
  <xsl:apply-templates/>
  </xsl:element>
  </xsl:when>
  <xsl:otherwise>
  <xsl:apply-templates/>
  </xsl:otherwise>
  </xsl:choose>
  </xsl:element>
</xsl:template>

<xsl:template match="secc2">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="secc2/titulo">
  <xsl:element name="h3">
  <xsl:choose>
  <xsl:when test="ancestor::secc2[@id]">
  <xsl:element name="a">
  <xsl:attribute name="name">
  <xsl:value-of select="ancestor::secc2/@id"/>
  </xsl:attribute>
  <xsl:apply-templates/>
  </xsl:element>
  </xsl:when>
  <xsl:otherwise>
  <xsl:apply-templates/>
  </xsl:otherwise>
  </xsl:choose>
  </xsl:element>
</xsl:template>

<xsl:template match="secc2/titulo" mode="crossref">
  <i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="secc3">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="secc3/titulo">
  <xsl:element name="h4">
  <xsl:choose>
  <xsl:when test="ancestor::secc3[@id]">
  <xsl:element name="a">
  <xsl:attribute name="name">
  <xsl:value-of select="ancestor::secc3/@id"/>
  </xsl:attribute>
  <xsl:apply-templates/>
  </xsl:element>
  </xsl:when>
  <xsl:otherwise>
  <xsl:apply-templates/>
  </xsl:otherwise>
  </xsl:choose>
  </xsl:element>
</xsl:template>

<xsl:template match="secc3/title" mode="crossref">
  <i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="secc4">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="secc4/titulo">
  <xsl:element name="h5">
  <xsl:choose>
  <xsl:when test="ancestor::secc4[@id]">
  <xsl:element name="a">
  <xsl:attribute name="name">
  <xsl:value-of select="ancestor::secc4/@id"/>
  </xsl:attribute>
  <xsl:apply-templates/>
  </xsl:element>
  </xsl:when>
  <xsl:otherwise>
  <xsl:apply-templates/>
  </xsl:otherwise>
  </xsl:choose>
  </xsl:element>
</xsl:template>

<xsl:template match="secc4/title" mode="crossref">
  <i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="secc5">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="secc5/titulo">
  <xsl:element name="h5">
  <xsl:choose>
  <xsl:when test="ancestor::secc5[@id]">
  <xsl:element name="a">
  <xsl:attribute name="name">
  <xsl:value-of select="ancestor::secc5/@id"/>
  </xsl:attribute>
  <xsl:apply-templates/>
  </xsl:element>
  </xsl:when>
  <xsl:otherwise>
  <xsl:apply-templates/>
  </xsl:otherwise>
  </xsl:choose>
  </xsl:element>
</xsl:template>

<xsl:template match="secc5/titulo" mode="crossref">
  <i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="titulo">
<h1><xsl:apply-templates/></h1>
</xsl:template>

<xsl:template match="fecha">
<br/><br/><xsl:apply-templates/>
</xsl:template>

<xsl:template match="version">
  <br/><xsl:text>Versin </xsl:text><xsl:apply-templates/>
</xsl:template>

<xsl:template match="contenido">
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="items">
  <ul>
  <xsl:apply-templates/>
  </ul>
</xsl:template>

<xsl:template match="secuencia">
  <ol>
  <xsl:apply-templates/>
  </ol>
</xsl:template>

<xsl:template match="glosario">
  <dl>
  <xsl:apply-templates/>
  </dl>
</xsl:template>

<xsl:template match="listado">
  <div align="center">
  <table width="90%" border="0" bgcolor="#cccccc">
  <tr><td><br/><br/><pre><xsl:apply-templates/></pre></td></tr>
  </table>
  </div>
</xsl:template>

<xsl:template match="glosario/termino">
  <dt>
  <b><xsl:apply-templates/></b>
  </dt>
</xsl:template>

<xsl:template match="glosario/definicion">
  <dd>
  <xsl:apply-templates/>
  </dd>
</xsl:template>

<xsl:template match="item">
  <li>
  <xsl:apply-templates/>
  </li>
</xsl:template>

<xsl:template match="para">
  <p>
  <xsl:apply-templates/>
  </p>
</xsl:template>

<xsl:template match="comillas">
  &quot;<xsl:apply-templates/>&quot;
</xsl:template>

<xsl:template match="comando">
  <b><xsl:apply-templates/></b>
</xsl:template>

<xsl:template match="enfasis">
  <i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="fichero">
  <i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="paquete">
  <b><xsl:apply-templates/></b>
</xsl:template>

<xsl:template match="clave">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="literal">
  <tt><xsl:apply-templates/></tt>
</xsl:template>

<xsl:template match="nota">
  (<small><xsl:apply-templates/></small>)
</xsl:template>

<xsl:template match="enlace">
  <xsl:element name="a">
  <xsl:attribute name="href">
  <xsl:value-of select="./@url"/>
  </xsl:attribute>
  <xsl:apply-templates/>
  </xsl:element>
</xsl:template>

<xsl:template match="figura">
  <br/><br/>
  <xsl:element name="div">
  <xsl:attribute name="align">
  <xsl:text>center</xsl:text>
  </xsl:attribute>
  <xsl:for-each select="grafica">
  <xsl:element name="img">
  <xsl:attribute name="src">
  <xsl:value-of select="@fichero"/>.<xsl:value-of select="@formato"/>
  </xsl:attribute>
  <xsl:attribute name="alt">
  <xsl:value-of select="@fichero"/>.<xsl:value-of select="@formato"/>
  </xsl:attribute>
  </xsl:element>
  </xsl:for-each>
  <br/><br/>
  <b>Fig. <xsl:value-of select="@etiqueta"/></b><xsl:apply-templates select="leyenda"/>
  </xsl:element>
  <br/><br/>
</xsl:template>

<xsl:template match="leyenda">
  <xsl:text>: </xsl:text><xsl:apply-templates/>
</xsl:template>

<xsl:template match="grafica">
  <xsl:element name="img">
  <xsl:attribute name="src">
  <xsl:value-of select="@fileref"/>.<xsl:value-of select="@format"/>
  </xsl:attribute>
  <xsl:attribute name="alt">
  <xsl:value-of select="@fileref"/>.<xsl:value-of select="@format"/>
  </xsl:attribute>
  </xsl:element>
</xsl:template>

<xsl:template match="ref">
  <xsl:variable name="id" select="@id"/>
  <xsl:element name="a">
  <xsl:attribute name="href">
  <xsl:text>#</xsl:text><xsl:value-of select="$id"/>
  </xsl:attribute>
  <xsl:apply-templates select="//*[@etiqueta=$id]/title"
			   mode="crossref"/>
  </xsl:element>
</xsl:template>

<xsl:template match="referencia">
  <p>
  <xsl:apply-templates/>
  </p>
</xsl:template>

<xsl:template match="lista">
  <table>
  <xsl:apply-templates/>
  </table>
</xsl:template>

<xsl:template match="elemento">
  <tr><td><xsl:apply-templates/></td></tr>
</xsl:template>

</xsl:stylesheet>
