
#ifndef XREF_H
#define XREF_H

/* This header declares a two-dimensional linked list.  The first
 * dimension is a list of all the rams, with their numbers and titles.
 * In the second dimension, each ram may subramify into other rams or
 * xref over to other rams.  */

#include "def.h"

struct xref;
struct xram {
  struct xram *next        ;
  struct xram *up          ; /* parent ram       */
  struct xref *sref        ; /* subramification  */
  struct xref *xref        ; /* cross-references */
  int          selected    ;
  char         ram[N_DIG+1];
  int          n_indent    ;
  int          ram_level   ;
  char        *title       ;
  int          n_deb       ;
};
struct xref {
  struct xref *next        ;
  struct xram *xram        ;
  char         ram[N_DIG+1];
};

extern struct xram xram0000;

struct xram *xref_pass     ( void              );
struct xram *first_selected( struct xram *xram );
struct xram *next_selected ( struct xram *xram );

#endif

