# debpartial_mirror - partial debian mirror package tool
# (c) 2006 Otavio Salvador <otavio@debian.org>
# (c) 2006 Marco Presi <zufus@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gnome
import gtk.glade
import gobject
import ConfigParser

#for debuggin purpose
import time

from debpartial_mirror import Backend
from debpartial_mirror import Config
from debpartial_mirror import Download

from Callbacks import *

name               = "gdebpartial-mirror"
version            = "0.0.1"
app_glade_file     = "debpartial_mirror_ui/interface/ui.glade"
backend_glade_file = "debpartial_mirror_ui/interface/backend_ui.glade"

MIRRORS = 0
MERGES = 1



class GDebPartialMirror:
    """ A class that represent the main interface """
    def __init__ (self, conffile):
        self.conffile  = conffile
        self.app = gnome.program_init (name, version)
        self.xml = gtk.glade.XML (app_glade_file)
        self.parse_conffile ()
        self.b_treeview = self.xml.get_widget ("backend_treeview")
        self.p_treeview = self.xml.get_widget ("property_treeview")
        (self.COLUMN_SEL,
         self.COLUMN_NAME) = range(2)

        (self.COLUMN_PROP,
         self.COLUMN_VALUE) = range(2)

        self.debug_mode = True
        auto_signals = {"on_open_activate": (on_open_activate, self),
                        "on_quit_activate": on_quit_activate,
                        "on_backend_treeview_event":  (on_backend_treeview_event, self),
                        "on_pop_up_update_activate":  (on_pop_up_update_activate, self),
                        "on_pop_up_upgrade_activate": (on_pop_up_upgrade_activate,self),
                        "on_b_update_clicked":        (on_b_update_clicked, self)}
    
        
        self.create_backends_treeview ()
        
        self.create_mirror_property_treeview ()
        self.xml.signal_autoconnect (auto_signals)



    def _get_backends (self, type):
        """Get the backend list from config file"""
        backend = []
        for b in self.cnf.get_backends()[type]:
            backend.append(Backend.MirrorBackend(b.section,
                                                 self.cnf))
        return backend
    
    def parse_conffile (self):
        """Parse the config file and checks for errors"""
        #TODO: handle error throught gerror, and display a dialog
        #      in case of failure
        try:
            self.cnf = Config.Config(self.conffile)

        except Config.InvalidOption, msg:
            print("Wrong option [%s] found on [%s] section of '%s'."
                  % (msg.option, msg.section, conffile))
            sys.exit(1)

        except Config.InvalidSection, msg:
            print("Wrong section [%s] found on '%s'."
                  % (msg.section, conffile))
            sys.exit(1)

        except Config.RequiredOptionMissing, msg:
            print("Required option [%s] was missing on [%s] section of '%s'."
                  % (msg.option, msg.section, conffile))
            sys.exit(1)

        self.mirrors = self._get_backends(MIRRORS)
        self.merges  = self._get_backends(MERGES)

    def create_mirror_property_treeview (self):
        """Create a treeview and a model to
           represent the property of a backend """
        self.prop_model = gtk.TreeStore (gobject.TYPE_STRING,
                                         gobject.TYPE_STRING)
        
        renderer = gtk.CellRendererText()
        renderer.set_property ("xalign", 0.0)
        column = gtk.TreeViewColumn('Properties',
                                    renderer,
                                    text=self.COLUMN_PROP)
        column.set_clickable(False)
        column.set_sort_column_id(self.COLUMN_PROP)
        self.p_treeview.append_column(column)

        column = gtk.TreeViewColumn('Values',
                                    renderer,
                                    text=self.COLUMN_VALUE)
        column.set_clickable(False)
        column.set_sort_column_id(self.COLUMN_VALUE)
        self.p_treeview.append_column(column)

        self.p_treeview.expand_all()
        self.p_treeview.set_rules_hint(True)
        self.p_treeview.show_all()
        

    def update_mirror_property_treeview (self, b_name):
        """Update the configuration values treeview  """
        self.prop_model.clear ()

        try:
            for b in self.cnf.options(b_name):
                print "Adding %s" %  b
                self.prop_iter = self.prop_model.append (None)
                self.prop_model.set (self.prop_iter,
                                     self.COLUMN_PROP, b,
                                     self.COLUMN_VALUE, self.cnf.get_option(b, b_name))
                
        except ConfigParser.NoSectionError:
            # If the selected row was not a backend, we simply ignore it
            if self.debug_mode: print "ConfigParser.NoSectionError"
            pass

        self.p_treeview.set_model (self.prop_model)

    def update_backends_treeview (self):
        """ Update the backend treeview"""
        self.model.clear ()

        mirrors_iter = self.model.append(None)
        self.model.set (mirrors_iter,
                        self.COLUMN_SEL, False,
                        self.COLUMN_NAME, "<b>Mirrors</b>")

        merges_iter = self.model.append(None)
        self.model.set (merges_iter,
                        self.COLUMN_SEL, False,
                        self.COLUMN_NAME, "<b>Merges</b>")

        for i in self.mirrors:
            mirrors_list_iter = self.model.append (mirrors_iter)
            self.model.set (mirrors_list_iter,
                            #self.COLUMN_SEL, None,
                            self.COLUMN_NAME, i._name)

        for i in self.merges:
            merges_list_iter = self.model.append (merges_iter)
            self.model.set (merges_list_iter,
                            #self.COLUMN_SEL, None,
                            self.COLUMN_NAME, i._name)
        
    
    def create_backends_treeview (self):
        """Create a treeview containing all the backends """
        self.model = gtk.TreeStore (gobject.TYPE_BOOLEAN,
                                    gobject.TYPE_STRING)

        self.update_backends_treeview ()
        self.b_treeview.set_model (self.model)

        #column for backend selection 
        t = gtk.CellRendererToggle()
        t.set_property ("activatable", True)
        t.connect ('toggled', backend_toggled_cb, self)
        column = gtk.TreeViewColumn('S',
                                    t,
                                    active=self.COLUMN_SEL)
        column.set_clickable(True)
        column.set_sort_column_id(self.COLUMN_SEL)
        self.b_treeview.append_column(column)

        #column for backend names
        renderer = gtk.CellRendererText()
        renderer.set_property ("xalign", 0.0)
        
        column = gtk.TreeViewColumn('Backend',
                                    renderer,
                                    #text=self.COLUMN_NAME,
                                    markup=self.COLUMN_NAME)

        column.set_clickable(True)
        column.set_sort_column_id(self.COLUMN_NAME)
        self.b_treeview.append_column(column)

        self.select = self.b_treeview.get_selection ()
        self.select.set_mode (gtk.SELECTION_SINGLE)
        self.select.connect ('changed', backend_selection_changed_cb, self)
        self.b_treeview.expand_all()
        self.b_treeview.set_rules_hint(True)
        self.b_treeview.show_all()
