package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;

/**
 * Window for editing control information of bugs
 * 
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: ControlWindow.java,v 1.6 2003/12/28 18:51:35 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class ControlWindow extends Window{

	private Bug bug;
	
	private ControlEdit controlEditControls;

	/**
	 * @param bug The bug to be edited
	 */
	public ControlWindow(Bug bug){
		super(WindowType.TOPLEVEL);
		this.bug = bug;
		
		setTitle("Edit Control data for bug #"+bug.getNumber());
		setBorderWidth(12);
		
		VBox vbox = new VBox(false, 0);
		add(vbox);


		controlEditControls = new ControlEdit(bug);
		vbox.packStart( controlEditControls, true, true, 0 );

		HButtonBox bb = new HButtonBox();
		bb.setLayout(ButtonBoxStyle.END);
		bb.setSpacing(6);
		vbox.packStart(bb, false, true, 0);

		Button addQueue = new Button( "Add to _Queue" );
		bb.add(addQueue);

		addQueue.addListener(new ButtonListener(){
			public void buttonEvent( ButtonEvent event ){
				if (event.isOfType( ButtonEvent.Type.CLICK )){
					addQueue();
				}
			}
		});

		Button sendNow = new Button( "Send _Now" );
		bb.add(sendNow);

		sendNow.addListener(new ButtonListener(){
			public void buttonEvent( ButtonEvent event ){
				if (event.isOfType( ButtonEvent.Type.CLICK )){
					generateEmail();
				}
			}
		});

		Button cancel = new Button( GtkStockItem.CANCEL );
		bb.add(cancel);
		cancel.addListener( new ButtonListener(){
			public void buttonEvent( ButtonEvent event ){
				if (event.isOfType( ButtonEvent.Type.CLICK )){
					cancel();
				}
			}
		});
	}

	private void addQueue(){
		ControlQueue.getInstance().addItem( controlEditControls.getControlMsg() );
		hide();
	}
		
	/**
	 */
	private void generateEmail(){
		String control = controlEditControls.getControlMsg(); 
		boolean needControl = (control != null && !control.equals("")); // should we send to  control@bugs?
		
		if (! needControl){
			// todo
			return;
		}
		org.gnu.gnome.Url.show("mailto:control@bugs.debian.org"
				+ "?subject=Bug #"+bug.getNumber() + ": "+bug.getTitle() 
				+ "&X-debbuggtk-Version="+DebbugGtk.VERSION
				+ "&body="+controlEditControls.getControlMsg());
		hide();
	}

	private void cancel(){
		hide();
	}
}
