package com.tildemh.debbuggtk;

import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.glade.*;
import org.gnu.gnome.*;
import org.gnu.gdk.*;
import java.io.*;

/**
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BugViewer.java,v 1.29 2004/04/21 20:20:05 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BugReporter implements ListingReportListener{
	
	public BugReporter(){
		makeWindow();
	}

	private BTS bts;
	private App app;

	private org.gnu.gnome.Entry pkg;

	private DruidPageEdge start;
	private DruidPageStandard specifypkg;
	private DruidPageStandard viewreports;
	private DruidPageStandard pkgspecific;
	private DruidPageStandard bugdetails;
	private DruidPageStandard details;
	private DruidPageEdge end;

	private Druid druid;

	private TextView pkgSpecificTxt;

	private VBox viewReportsVBox;
	private org.gnu.gtk.Entry shortdesc;
	private VBox bugdetailsvbox;
	private TextView fullReport;
	private ProgressBar listingProgress;
	private org.gnu.gtk.Entry listingEntry;

	private String chosenPackage = "general";
	
	private void makeWindow(){
		DebbugGtk.newWindow();
		WindowIcon.setDefaultIcon(DebbugGtk.ICON);
		
		String filename = DebbugGtk.GLADE_XML_DIR+"/bugreporter.glade";
		LibGlade glade = null;
		try {
			glade = new LibGlade(filename, this, null);
		} catch (GladeXMLException e) {
			throw new RuntimeException("Error parsing glade XML file." + e);
		} catch (FileNotFoundException e) {
			throw new RuntimeException("Glade XML file not found.");
		} catch (IOException e) {
			throw new RuntimeException("Error reading glade XML file.");
		}

		app = (App) glade.getWidget("BugReporter");
		app.addListener( DebbugGtk.lifeCycleListener );
		app.setTitle("BugReporter "+DebbugGtk.VERSION);
		
		druid = (Druid) glade.getWidget("druid");
		druid.getFinishButton().setLabel("Send Report");
		start = (DruidPageEdge) glade.getWidget("start");
		specifypkg = (DruidPageStandard) glade.getWidget("specifypkg");
		viewreports = (DruidPageStandard) glade.getWidget("viewreports");
		pkgspecific = (DruidPageStandard) glade.getWidget("pkgspecific");
		bugdetails = (DruidPageStandard) glade.getWidget("bugdetails");
		details = (DruidPageStandard) glade.getWidget("details");
		end = (DruidPageEdge) glade.getWidget("end");
		pkg = (org.gnu.gnome.Entry) glade.getWidget( "pkg" );
		pkgSpecificTxt = (TextView) glade.getWidget("pkgSpecificTxt");
		shortdesc = (org.gnu.gtk.Entry) glade.getWidget("shortdesc");
		bugdetailsvbox = (VBox) glade.getWidget("bugdetailsvbox");
		fullReport = (TextView) glade.getWidget("fullReport");
		listingProgress = (ProgressBar) glade.getWidget("listingProgress");
		listingEntry = (org.gnu.gtk.Entry) glade.getWidget("listingEntry");
		viewReportsVBox = (VBox) glade.getWidget("viewReportsVBox");
	
		start.setLogo( new Pixbuf( DebbugGtk.ICON ) );
		specifypkg.setLogo( new Pixbuf( DebbugGtk.ICON ) );
		viewreports.setLogo( new Pixbuf( DebbugGtk.ICON ) );
		pkgspecific.setLogo( new Pixbuf( DebbugGtk.ICON ) );
		bugdetails.setLogo( new Pixbuf( DebbugGtk.ICON ) );
		details.setLogo( new Pixbuf( DebbugGtk.ICON ) );
		end.setLogo( new Pixbuf( DebbugGtk.ICON ) );

		app.showAll();
	}


	public static void main(String[] args){
		Thread.currentThread().setPriority( Thread.MAX_PRIORITY );
		 Program.initGnomeUI("debbuggtk", DebbugGtk.VERSION, args);
		new BugReporter();
		Gtk.main();
	}

	public void cancel(){
		System.out.println("cancel clicked");
		app.hide();
		DebbugGtk.closeWindow();
	}
	public void help(){
		try{
			Help.display( "debbuggtk", "bugreporter" );
		}catch( HelpException e ){
			e.printStackTrace();
			throw new RuntimeException( e.toString() );
		}
	}
	public void guesspkg(){
		System.out.println("guesspkg clicked");
		// todo
	}

	public void specifypkgNext(){
		chosenPackage  = pkg.getEntry().getText();
		// todo:
		// Check package is a real package
		// Warn if not installed
		// Warn if not latest version
		// ...
		// see reportbug feature list
	}

	private boolean listingReportAdded = false;
	private ListingReport listing;
	public void checkReportsPrepare(){
		// TODO - load reports.
		if (! listingReportAdded ){
			listing = new ListingReport( this, app, true );
			viewReportsVBox.packStart( listing, true, true, 0 );
			listingReportAdded = true;
		}
		listing.setPackage( new ListingStub( ListingType.BINARY, chosenPackage ) );
		listing.showAll();
	}
	public void listingSelectionChanged(com.tildemh.debbug.Bug bug){
		new BugViewer( bug );
	}
	public void listingChanged( ListingStub newListing ){ }
	public void listingReportStateChanged( ListingState state ){
		// TODO: detect done state then hide progress bar
		listingEntry.setText( state.toString() );
		listingProgress.setFraction( (double) state.getCurrent() / (double) state.getMax() );
	}

	public void checkReportsNext(){
		alternative = bugdetails;
		//go to pkg specific?
	}
	public void checkReportsBack(){}

	public void bugDetailsBack(){
		alternative = viewreports;
		//go to pkg specific?
	}

	private DruidPage alternative = null;

	public void pkgSpecificPrepare(){
		String filename = "/usr/share/bug/"+chosenPackage+"/presubj";
		//System.out.println("goPkgSpecific - looking for " + filename);
		File info = new File( filename );
		if (info.exists()){
			//System.out.println("presubj exists!!!");
			String message = "";
			try{
				try{
					StringBuffer msg = new StringBuffer("");
					BufferedReader br = new BufferedReader( new FileReader( info ) );
					String m = br.readLine();
					while ( m != null){
						//System.out.println(m);
						msg.append("\n");
						msg.append( m );
						m = br.readLine() ;
					}
					message = msg.toString();
				}catch(FileNotFoundException e ){
					System.err.println("ERROR: File not found: "+filename);
					e.printStackTrace();
					message = "Error: "+filename+" not found!";
				}catch( IOException e ){
					System.err.println("ERROR: IO error reading " + filename);
					e.printStackTrace();
					message = "IOException while reading " + filename;
				}
			}finally{
				//System.out.println("Pkg message is: "+message);
				pkgSpecificTxt.getBuffer().setText( message );
			}
		}else{
			if (alternative == null){
				throw new RuntimeException("eeek");
			}
			druid.setPage( alternative );
			alternative = null;
		}
	}
	
	private boolean bugdetailsmade = false;
	private LibGlade bugdetailsGlade;
	private OptionMenu severity;
	public void bugDetailsPrepare(){
		if (bugdetailsmade) return;
			String filename = DebbugGtk.GLADE_XML_DIR+"/controledit.glade";
		LibGlade glade = null;
		try {
			glade = new LibGlade(filename, this, "fixedcontrols");
		} catch (GladeXMLException e) {
			throw new RuntimeException("Error parsing glade XML file." + e);
		} catch (FileNotFoundException e) {
			throw new RuntimeException("Glade XML file not found.");
		} catch (IOException e) {
			throw new RuntimeException("Error reading glade XML file.");
		}
		bugdetailsvbox.packStart( glade.getWidget("fixedcontrols"), true, true, 0);

		bugdetailsmade = true;
		severity = (OptionMenu) glade.getWidget("severity");
		severity.setHistory( 5 );
		bugdetailsGlade = glade;
	}

	private String getTags(){
		StringBuffer buffer = new StringBuffer();		
		LibGlade glade = bugdetailsGlade;
		if (((CheckButton) glade.getWidget("patchTag")).getState()) buffer.append("patch ");
		if (((CheckButton) glade.getWidget("securityTag")).getState()) buffer.append("security ");
		if (((CheckButton) glade.getWidget("upstreamTag")).getState()) buffer.append("upstream ");
		if (((CheckButton) glade.getWidget("potatoTag")).getState()) buffer.append("potato ");
		if (((CheckButton) glade.getWidget("woodyTag")).getState()) buffer.append("woody ");
		if (((CheckButton) glade.getWidget("sargeTag")).getState()) buffer.append("sarge ");
		if (((CheckButton) glade.getWidget("sidTag")).getState()) buffer.append("sid ");
		if (((CheckButton) glade.getWidget("experimentalTag")).getState()) buffer.append("experimental ");
	
		if (((CheckButton) glade.getWidget("d_iTag")).getState()) buffer.append("d-i ");
		if (((CheckButton) glade.getWidget("ipv6Tag")).getState()) buffer.append("ipv6 ");
		if (((CheckButton) glade.getWidget("lfsTag")).getState()) buffer.append("lfs ");
		return buffer.toString();
	}
	private String getSeverity(){
		int hist = severity.getHistory();
		int sevValue = -1;
		switch (hist) {
			case 0: sevValue = 0; break;
			case 1: sevValue = 1; break;
			case 2: sevValue = 2; break;
			case 4: sevValue = 3; break;
			case 5: sevValue = 5; break;
			case 6: sevValue = 6; break;
			case 8: sevValue = 7; break;
		};
		return Severity.fromValue(sevValue).toString();
	}
	
	public void sendReport(){
		// todo: check that all fields (e.g. desc) are present and correct
		StringBuffer msg = new StringBuffer("");
		msg.append( "Package: ");
		msg.append( chosenPackage );
		msg.append( "\nVersion: ");
		msg.append( Packages.getVersion( chosenPackage ) );
		msg.append( "Severity: ");
		msg.append( getSeverity() );
		String tags = getTags();
		if (tags != null && !tags.equals("") ){
			msg.append( "\nTags: " );
			msg.append( tags );
		}
		msg.append( "\n\n" );
		TextBuffer b = fullReport.getBuffer();
		msg.append( b.getText( b.getStartIter(), b.getEndIter(), false) );
		msg.append( "\n\n" );

		msg.append( Packages.getSystemInfo( chosenPackage ) );
		org.gnu.gnome.Url.show("mailto:submit@bugs.debian.org?subject="+shortdesc.getText() + "&body="+msg.toString()+ "&X-debbuggtk-Version="+DebbugGtk.VERSION );
		app.hide();
		DebbugGtk.closeWindow();
	}

}
