package com.tildemh.debbug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * Methods for obtaining information about installed packages
 * 
 * @version $Id: Packages.java,v 1.6 2003/12/24 12:36:54 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2003
 */
public class Packages{

	private Packages() {} // no instantiation


	/**
	 * Returns a formatted block of text to use as the system info section of an
	 * email to the bts.
	 */
	public static final String getSystemInfo( String pkg ){
		StringBuffer report = new StringBuffer();
	
		try{
			Process rb = Runtime.getRuntime().exec( "reportbug --template "+pkg );
			rb.waitFor();
			BufferedReader br = new BufferedReader( new InputStreamReader( rb.getInputStream() ));
			String line = br.readLine();
			boolean sysinfo = false;
			while ( line != null ){
				if (!sysinfo){
					sysinfo = line.equals("-- System Information:");
				}
				if (sysinfo){
					report.append( line );
					report.append("\n");
				}
				line = br.readLine();
			}
		}catch(IOException e){ 
			// do nothing
		}catch(InterruptedException e){
		}
		
		if (report.length() <= 0){
			return "Error obtaining system info";
		}else{
			return report.toString();
		}
	}

	public static final String getDebianRelease(){
		return "Probaby unstable release";
	}

	public static final String getVersion( String pkg ){
		StringBuffer report = new StringBuffer();
		try{
			//System.out.println("dpkg --status  "+pkg +" | grep Version ");
			//String cmd = "bash -c \"dpkg --status galeon | sed -ne \\\"s/Version: \\(.*\\)/\\1\\n/p\\\"\"";
			String cmd = "dpkg --status "+pkg;
			System.out.println(cmd);
			Process rb = Runtime.getRuntime().exec( cmd );
			//Process dpkg = Runtime.getRuntime().exec( "dpkg --status  "+pkg );
			//Process rb = Runtime.getRuntime().exec( "sed -ne \"s/Version: \\(.*\\)/\\1/p\"");
			rb.waitFor();
			BufferedReader br = new BufferedReader( new InputStreamReader( rb.getInputStream() ));
			String line = br.readLine();
			while ( line != null ){
				if (line.indexOf("Version: ") >= 0 ){
					report.append( line.substring(9) );
					report.append("\n");
					System.out.println(line);
				}
				line = br.readLine();
			}
			BufferedReader err = new BufferedReader( new InputStreamReader( rb.getErrorStream() ));
			line = err.readLine();
			while ( line != null ){
				System.err.println(line);
				line = err.readLine();
			}
		}catch(IOException e){ 
			e.printStackTrace();
			// do nothing
		}catch(InterruptedException e){
			e.printStackTrace();
		}
		if (report.length() <= 0){
			return "unknown";
		}else{
			return report.toString();
		}
		
		//return "unknown";
	}
	
	public static final String getStatus( String pkg ){
/*		StringBuffer report = new StringBuffer();
		try{
			Process rb = Runtime.getRuntime().exec( "bash -c \"dpkg --status  "+pkg +" | grep Status | sed -e 's/Status: \\(.*\\)/\\1/' \"");
			rb.waitFor();
			BufferedReader br = new BufferedReader( new InputStreamReader( rb.getInputStream() ));
			String line = br.readLine();
			while ( line != null ){
				report.append( line );
				report.append("\n");
				line = br.readLine();
			}
		}catch(IOException e){ 
			// do nothing
		}catch(InterruptedException e){
		}
		if (report.length() <= 0){
			return "unknown";
		}else{
			return report.toString();
		}*/
		return "unknown";
	}
}
