package com.tildemh.debbug;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.util.LinkedList;
import java.util.Vector;

/**

 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BugFile.java,v 1.14 2004/04/22 12:20:13 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BugFile{

	private static final int VERSION = 4;
	private static final String LISTING_END = "end of listing list";
	private static final String TAGS_END = "end of tags list";

	public BugFile() {} // no instantiation

	public static void storeBug( Bug bug, File file ) throws IOException{
		 if (bug.getComments() == null || bug.getComments().size() <= 0){
		 	// This in fact is quite comman and acceptable - when creating a bug, status changes will cause it to try to save itself, before any comments have been added.
		 	// --Need to change this in future when not all bugs have comments.
			//System.out.println("BIG ERROR: storeBug called with no comments in bug report!!!");
			
		//	(new Exception("Cowardly refusing to write bug file without comments")).printStackTrace();
			return;
		}
		PrintWriter out = new PrintWriter( new BufferedWriter( new FileWriter( file ) ) );
		out.println("Version: "+VERSION);
		out.println( Integer.toString( bug.getNumber()) );
		out.println( bug.getPackageName() );
		out.println( bug.getSeverity().toString() );
		out.println( bug.getTitle() );
		out.println( bug.getSubmitter() );
		out.println( Long.toString(bug.getCreated()) );
		out.println( bug.getStatus().toString() );
		out.println( bug.getForwarded() );
		out.println( bug.getDone() );
		
		StringBuffer m = new StringBuffer();
		int[] merged = bug.getMerged();
		for( int i = 0; i < merged.length; i++)
			m.append( merged[i] + " " );
		out.println( m.toString() );
		out.println( bug.getTagPatch() ? "1": "0" );
		out.println( bug.getTagSecurity() ? "1": "0" );
		out.println( bug.getTagUpstream() ? "1": "0" );
		out.println( bug.getTagPotato() ? "1": "0" );
		out.println( bug.getTagWoody() ? "1": "0" );
		out.println( bug.getTagSarge() ? "1": "0" );
		out.println( bug.getTagSid() ? "1": "0" );
		out.println( bug.getTagExperimental() ? "1": "0" );
		out.println( bug.getTagFixed() ? "1": "0" );
		out.println( bug.getTagPending() ? "1": "0" );
		out.println( bug.getTagHelp() ? "1": "0" );
		out.println( bug.getTagUnreproducible() ? "1": "0" );
		out.println( bug.getTagD_I() ? "1": "0" );
		out.println( bug.getTagConfirmed() ? "1": "0" );
		out.println( bug.getTagIPV6() ? "1": "0" );
		out.println( bug.getTagLFS() ? "1": "0" );
		out.println( bug.getTagWontfix() ? "1" :"0" );
		out.println( bug.getTagMoreinfo() ? "1": "0" );

		Vector otherTags = bug.getTagOthers();
		for( int i = 0; i < otherTags.size(); i++){
			out.println( (String) otherTags.get(i) );
		}
		out.println( TAGS_END );
		
		Vector listings = bug.getListings();
		for( int i = 0; i < listings.size(); i++ ){
			ListingStub listing = (ListingStub) listings.get(i);
			out.println( listing.getName() );
			ListingType type = listing.getType();
			out.println( type.getTitle() );
			out.println( type.getIncludeClosed() ? "all" : "open" );
			out.println( type.getValue() );
			out.println( type.getInfo() );
		}
		out.println(LISTING_END);

		LinkedList comments = bug.getComments();
		int i = comments.size();
		for (int j = 0; j< i; j++){
			out.println( ((BugComment) comments.removeFirst()).getSource() );
			out.println("BUGCOMMENTBOUNDARY!!!!!!!");
		}		
		out.close();
		file.setLastModified( bug.getLastUpdated() );
	}

	public static Bug loadBug( File f ) throws IOException, StreamCorruptedException{
		Bug bug = Bug.makeBug();
		bug.setNoWrite(true);
		try{
			BufferedReader in = new BufferedReader( new FileReader( f ) );
			if (!in.readLine().equals( "Version: "+VERSION )){
				throw new StreamCorruptedException( "Version: "+VERSION+" not found at start of file." );
			}
			bug.setNumber( Integer.parseInt( in.readLine() ) );
			bug.setPackageName( in.readLine() );
			bug.setSeverity( Severity.parse( in.readLine() ) );
			bug.setTitle( in.readLine() );
			bug.setSubmitter( in.readLine() );
			long c  = Long.parseLong( in.readLine() );
			bug.setCreated( c );

			c = f.lastModified() ;
			bug.setLastUpdated( c );

			bug.setStatus( Status.parse( in.readLine() ) );
			bug.setForwarded( in.readLine() );
			bug.setDone( in.readLine() );
			
			bug.setMerged( new int[0] );
			String merged = in.readLine();
			while (!merged.equals("")){
				if (merged.indexOf(" ") > 0){
			 		bug.addMerged( Integer.parseInt( merged.substring(0, merged.indexOf(" ")) ));
					merged = merged.substring( merged.indexOf(" ") + 1 );
				}else{
			 		bug.addMerged( Integer.parseInt( merged ) );
				}
			}

			bug.setTagPatch( in.readLine().equals("1") );
			bug.setTagSecurity( in.readLine().equals("1") );
			bug.setTagUpstream( in.readLine().equals("1") );
			bug.setTagPotato( in.readLine().equals("1") );
			bug.setTagWoody( in.readLine().equals("1") );
			bug.setTagSarge( in.readLine().equals("1") );
			bug.setTagSid( in.readLine().equals("1") );
			bug.setTagExperimental( in.readLine().equals("1") );
			bug.setTagFixed( in.readLine().equals("1") );
			bug.setTagPending( in.readLine().equals("1") );
			bug.setTagHelp( in.readLine().equals("1") );
			bug.setTagUnreproducible( in.readLine().equals("1") );
			bug.setTagD_I( in.readLine().equals("1") );
			bug.setTagConfirmed( in.readLine().equals("1") );
			bug.setTagIPV6( in.readLine().equals("1") );
			bug.setTagLFS( in.readLine().equals("1") );
			bug.setTagWontfix( in.readLine().equals("1") );
			bug.setTagMoreinfo( in.readLine().equals("1") );

			
			Vector listings = new Vector();
			String next = in.readLine();

			// Some bug files may not include TAGS_END. if they don't, they
			// won't include listings either.
			while (! next.equals(TAGS_END) 
					&& ! next.equals(LISTING_END) ){
				bug.addTagOthers( next );
				next = in.readLine();
			}
			if ( 	next.equals(TAGS_END) ) next = in.readLine();
			while (!next.equals(LISTING_END)){
				String name = next;
				String typeTitle = in.readLine();
				boolean includeClosed = in.readLine().equals("all");
				int typeVal = Integer.parseInt( in.readLine() );
				String typeInfo = in.readLine();
				ListingType type = new ListingType( typeVal, typeInfo, typeTitle, includeClosed );				
				listings.add( new ListingStub (type, name) );
				next = in.readLine();				
			}
			bug.setListings( listings );
					
			LinkedList comments = new LinkedList();
			StringBuffer cmt = null;
			String curLine = in.readLine();
			while( curLine != null ){
				if (curLine.equals("BUGCOMMENTBOUNDARY!!!!!!!")){
				//System.out.println("COMMENT: "+cmt.toString());
					comments.addLast( new BugComment( cmt.toString() ) );
					cmt = null;
				}else{
					if (cmt == null){
						cmt = new StringBuffer("");
					}else{
						cmt.append("\n");
					}
					cmt.append(curLine);
				}
				curLine = in.readLine();
			}
			bug.setComments( comments );
			bug.setComplete(true);
		}catch( NumberFormatException e ){
			throw new StreamCorruptedException( e.toString() );
		}
		bug.setNoWrite(false);
	 	return bug;
	} 

}
