package com.tildemh.debbuggtk;


import com.tildemh.debbug.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;
import org.gnu.glib.*;
import java.util.*;

/**
 * Container for displaying Package reports.
 *
 * <p>This includes package data, status and listings of all bugs in the
 * package. 
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: PkgReport.java,v 1.7 2002/12/22 12:23:35 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class PkgReport extends Container{
	
	private ListStore store;
	private TreeView view;
	private TreeSelection selection;
	private TreeSelectionListener selListener;

	private CellRendererText descRend;
	/**
	 */

	private void init(PkgReportListener listener){
		store = new ListStore( new Type[] { Type.JAVA_OBJECT(), Type.STRING(), Type.STRING(), Type.STRING() });


		view = new TreeView(store);
		view.setAlternateRowColor(true);
		view.setEnableSearch(true);
		view.setHeadersClickable(true);

		selection = view.getSelection();
		final PkgReportListener lst = listener;
		selListener = new TreeSelectionListener(){
			public void selectionChangedEvent(TreeSelectionEvent event){

				TreeSelectionForEach fe = new TreeSelectionForEach(){
					public void forEach(TreeModel model, TreePath path, TreeIter iter){
						lst.selChanged((Bug) store.getObjectValue(iter, 0));
//						System.out.println( store.getStringValue(iter, 2));
					}
				};
				
				view.getSelection().forEachSelected(fe);
			}
		};
		selection.addListener( selListener );

		
		
		TreeViewColumn numCol = new TreeViewColumn();
		numCol.setTitle("Bug #");
		view.appendColumn(numCol);
		CellRendererText numRend = new CellRendererText();
		numCol.packStart(numRend, true);
		numCol.addAttributeMapping(numRend, CellRendererText.Attribute.TEXT, 1);
		numCol.setResizable(true);
		numCol.setReorderable(true);
		numCol.setSortColumnID(1);
		
		TreeViewColumn severityCol = new TreeViewColumn();
		severityCol.setTitle("Severity");
		view.appendColumn(severityCol);
		CellRendererText severityRend = new CellRendererText();
		severityCol.packStart(severityRend, true);
		severityCol.addAttributeMapping(severityRend, CellRendererText.Attribute.TEXT, 3);
		severityCol.setResizable(true);
		severityCol.setReorderable(true);
		severityCol.setSortColumnID(3);
		
		TreeViewColumn descCol = new TreeViewColumn();
		descCol.setTitle("Title");
		view.appendColumn(descCol);
		descRend = new CellRendererText();
		descCol.packStart(descRend, true);
		descCol.addAttributeMapping(descRend, CellRendererText.Attribute.TEXT, 2);
		descCol.setResizable(true);
		descCol.setReorderable(true);
		descCol.setSortColumnID(2);
		view.setSearchColumn(descCol);
		
		handle = view.getHandle();		
	}

	CellRendererTextListener listener = new CellRendererTextListener(){
		public void cellRendererTextEvent(CellRendererTextEvent event){
			System.out.println(event);
		}
	};

	public void setPackage(Listing pkg){
		// 0 - Bug report
		// 0 - number
		// 1 - description
		// 2 - severity 
		// 3 - age
		//   - fixed
		//   - pending
		//   - help
		//   - morinfo
		//   - unreroducible
		store.clear();
	
		LinkedList bugs = pkg.getBugs();

		while (bugs.size()>0){
			Bug bug = (Bug) bugs.removeFirst();
			TreeIter iter = store.appendRow();
			store.setValue(iter, 0, (Object) bug);
			store.setValue(iter, 1, Integer.toString(bug.getNumber()) );
			store.setValue(iter, 2, bug.getTitle() );
			store.setValue(iter, 3, bug.getSeverity().toString() );
		}
	}
		
	public PkgReport(Listing pkg, PkgReportListener listener){
		init(listener);
		setPackage(pkg);
	}
	
	public PkgReport(PkgReportListener listener){
		init(listener);
	}
}

